/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ezmorph.array;

import java.lang.reflect.Array;
import java.util.Objects;
import net.sf.ezmorph.MorphException;
import net.sf.ezmorph.array.AbstractArrayMorpher;
import net.sf.ezmorph.primitive.DoubleMorpher;

public final class DoubleArrayMorpher
extends AbstractArrayMorpher {
    private static final Class DOUBLE_ARRAY_CLASS = double[].class;
    private double defaultValue;

    public DoubleArrayMorpher() {
        super(false);
    }

    public DoubleArrayMorpher(double defaultValue) {
        super(true);
        this.defaultValue = defaultValue;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DoubleArrayMorpher)) {
            return false;
        }
        DoubleArrayMorpher other = (DoubleArrayMorpher)obj;
        if (this.isUseDefault() && other.isUseDefault()) {
            return Objects.equals(this.getDefaultValue(), other.getDefaultValue());
        }
        return !this.isUseDefault() && !other.isUseDefault();
    }

    public double getDefaultValue() {
        return this.defaultValue;
    }

    public int hashCode() {
        if (this.isUseDefault()) {
            return Objects.hashCode(this.getDefaultValue());
        }
        return 17;
    }

    @Override
    public Object morph(Object array) {
        if (array == null) {
            return null;
        }
        if (DOUBLE_ARRAY_CLASS.isAssignableFrom(array.getClass())) {
            return (double[])array;
        }
        if (array.getClass().isArray()) {
            DoubleMorpher morpher;
            int length = Array.getLength(array);
            int dims = this.getDimensions(array.getClass());
            int[] dimensions = this.createDimensions(dims, length);
            Object result = Array.newInstance(Double.TYPE, dimensions);
            DoubleMorpher doubleMorpher = morpher = this.isUseDefault() ? new DoubleMorpher(this.defaultValue) : new DoubleMorpher();
            if (dims == 1) {
                for (int index = 0; index < length; ++index) {
                    Array.setDouble(result, index, morpher.morph(Array.get(array, index)));
                }
            } else {
                for (int index = 0; index < length; ++index) {
                    Array.set(result, index, this.morph(Array.get(array, index)));
                }
            }
            return result;
        }
        throw new MorphException("argument is not an array: " + String.valueOf(array.getClass()));
    }

    @Override
    public Class morphsTo() {
        return DOUBLE_ARRAY_CLASS;
    }
}

