/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ezmorph.array;

import java.lang.reflect.Array;
import java.util.Objects;
import net.sf.ezmorph.MorphException;
import net.sf.ezmorph.array.AbstractArrayMorpher;
import net.sf.ezmorph.primitive.CharMorpher;

public final class CharArrayMorpher
extends AbstractArrayMorpher {
    private static final Class CHAR_ARRAY_CLASS = char[].class;
    private char defaultValue;

    public CharArrayMorpher() {
        super(false);
    }

    public CharArrayMorpher(char defaultValue) {
        super(true);
        this.defaultValue = defaultValue;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CharArrayMorpher)) {
            return false;
        }
        CharArrayMorpher other = (CharArrayMorpher)obj;
        if (this.isUseDefault() && other.isUseDefault()) {
            return Objects.equals(Character.valueOf(this.getDefaultValue()), Character.valueOf(other.getDefaultValue()));
        }
        return !this.isUseDefault() && !other.isUseDefault();
    }

    public char getDefaultValue() {
        return this.defaultValue;
    }

    public int hashCode() {
        if (this.isUseDefault()) {
            return Objects.hashCode(Character.valueOf(this.getDefaultValue()));
        }
        return 17;
    }

    @Override
    public Object morph(Object array) {
        if (array == null) {
            return null;
        }
        if (CHAR_ARRAY_CLASS.isAssignableFrom(array.getClass())) {
            return (char[])array;
        }
        if (array.getClass().isArray()) {
            CharMorpher morpher;
            int length = Array.getLength(array);
            int dims = this.getDimensions(array.getClass());
            int[] dimensions = this.createDimensions(dims, length);
            Object result = Array.newInstance(Character.TYPE, dimensions);
            CharMorpher charMorpher = morpher = this.isUseDefault() ? new CharMorpher(this.defaultValue) : new CharMorpher();
            if (dims == 1) {
                for (int index = 0; index < length; ++index) {
                    Array.setChar(result, index, morpher.morph(Array.get(array, index)));
                }
            } else {
                for (int index = 0; index < length; ++index) {
                    Array.set(result, index, this.morph(Array.get(array, index)));
                }
            }
            return result;
        }
        throw new MorphException("argument is not an array: " + String.valueOf(array.getClass()));
    }

    @Override
    public Class morphsTo() {
        return CHAR_ARRAY_CLASS;
    }
}

