/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.monitoring;

import hudson.Extension;
import hudson.model.Computer;
import hudson.model.TaskListener;
import hudson.slaves.ComputerListener;
import hudson.slaves.OfflineCause;
import java.io.IOException;
import jenkins.model.Jenkins;
import net.bull.javamelody.NodesCollector;
import org.jvnet.hudson.plugins.monitoring.HudsonMonitoringFilter;
import org.jvnet.hudson.plugins.monitoring.PluginImpl;

@Extension
public class NodesListener
extends ComputerListener {
    private NodesCollector nodesCollector;

    public void onOnline(Computer c, TaskListener listener) throws IOException, InterruptedException {
        this.scheduleCollectNow();
        super.onOnline(c, listener);
    }

    public void onOffline(Computer c, OfflineCause cause) {
        this.scheduleCollectNow();
        super.onOffline(c, cause);
    }

    private void scheduleCollectNow() {
        try {
            NodesCollector collector = this.getNodesCollector();
            if (collector != null) {
                collector.scheduleCollectNow();
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private NodesCollector getNodesCollector() {
        HudsonMonitoringFilter monitoringFilter;
        PluginImpl pluginImpl;
        Jenkins jenkins;
        if (this.nodesCollector == null && (jenkins = Jenkins.getInstance()) != null && (pluginImpl = (PluginImpl)jenkins.getPlugin(PluginImpl.class)) != null && (monitoringFilter = pluginImpl.getFilter()) != null) {
            this.nodesCollector = monitoringFilter.getNodesCollector();
        }
        return this.nodesCollector;
    }
}

