/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import jenkins.model.Jenkins;
import net.bull.javamelody.Collector;
import net.bull.javamelody.Counter;
import net.bull.javamelody.CounterRunListener;
import net.bull.javamelody.JavaInformations;
import net.bull.javamelody.JdbcWrapper;
import net.bull.javamelody.LOG;
import net.bull.javamelody.MailReport;
import net.bull.javamelody.MonitoringFilter;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.Parameters;
import net.bull.javamelody.Period;
import net.bull.javamelody.RemoteCallHelper;

public class NodesCollector {
    private final boolean monitoringDisabled = Boolean.parseBoolean(Parameters.getParameter((Parameter)Parameter.DISABLED));
    private final Timer timer;
    private final Collector collector;
    private Map<String, JavaInformations> lastJavaInformationsList;

    public NodesCollector(MonitoringFilter filter) {
        if (!this.monitoringDisabled) {
            this.timer = filter.getFilterContext().getTimer();
            List<Counter> counters = Collections.singletonList(CounterRunListener.getBuildCounter());
            this.collector = new RemoteCollector("nodes", counters);
        } else {
            this.timer = null;
            this.collector = null;
        }
    }

    public void init() {
        if (this.monitoringDisabled) {
            return;
        }
        int periodMillis = Parameters.getResolutionSeconds() * 1000;
        TimerTask collectTask = new TimerTask(){

            @Override
            public void run() {
                NodesCollector.this.collectWithoutErrors();
            }
        };
        this.timer.schedule(collectTask, 5000L, (long)periodMillis);
        if (Parameters.getParameter((Parameter)Parameter.MAIL_SESSION) != null && Parameters.getParameter((Parameter)Parameter.ADMIN_EMAILS) != null) {
            this.scheduleReportMailForSlaves();
        }
    }

    public void scheduleCollectNow() {
        if (this.monitoringDisabled) {
            return;
        }
        TimerTask collectTask = new TimerTask(){

            @Override
            public void run() {
                NodesCollector.this.collectWithoutErrors();
            }
        };
        this.timer.schedule(collectTask, 0L);
    }

    public void stop() {
        if (this.monitoringDisabled) {
            return;
        }
        this.timer.cancel();
        this.collector.stop();
    }

    boolean isNodesMonitoringDisabled() {
        return Boolean.parseBoolean(System.getProperty("javamelody.nodes-monitoring-disabled"));
    }

    public void collectWithoutErrors() {
        try {
            if (this.isNodesMonitoringDisabled()) {
                return;
            }
            this.collectWithoutErrorsNow();
        }
        catch (Throwable t) {
            LOG.warn((String)"exception while collecting data", (Throwable)t);
        }
    }

    public void collectWithoutErrorsNow() {
        try {
            this.lastJavaInformationsList = new RemoteCallHelper(null).collectJavaInformationsListByName();
            Jenkins jenkins = Jenkins.getInstance();
            if (jenkins != null) {
                int queueLength = jenkins.getQueue().getBuildableItems().size();
                JdbcWrapper.BUILD_QUEUE_LENGTH.set(queueLength);
            }
            ArrayList<JavaInformations> javaInformations = new ArrayList<JavaInformations>(this.getLastJavaInformationsList().values());
            this.collector.collectWithoutErrors(javaInformations);
        }
        catch (Throwable t) {
            LOG.warn((String)"exception while collecting data", (Throwable)t);
        }
    }

    private void scheduleReportMailForSlaves() {
        for (Period period : MailReport.getMailPeriods()) {
            this.scheduleReportMailForSlaves(period);
        }
    }

    void scheduleReportMailForSlaves(final Period period) {
        assert (period != null);
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                try {
                    ArrayList<JavaInformations> javaInformations = new ArrayList<JavaInformations>(NodesCollector.this.getLastJavaInformationsList().values());
                    new MailReport().sendReportMail(NodesCollector.this.getCollector(), true, javaInformations, period);
                }
                catch (Throwable t) {
                    LOG.warn((String)"sending mail report failed", (Throwable)t);
                }
                NodesCollector.this.scheduleReportMailForSlaves(period);
            }
        };
        this.timer.schedule(task, MailReport.getNextExecutionDate((Period)period));
    }

    Collector getCollector() {
        return this.collector;
    }

    Map<String, JavaInformations> getLastJavaInformationsList() {
        return this.lastJavaInformationsList;
    }

    public boolean isMonitoringDisabled() {
        return this.monitoringDisabled;
    }

    private static class RemoteCollector
    extends Collector {
        RemoteCollector(String application, List<Counter> counters) {
            super(application, counters);
        }

        void collectLocalContextWithoutErrors() {
        }
    }
}

