/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.monitoring;

import hudson.model.Hudson;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.bull.javamelody.MonitoringFilter;
import net.bull.javamelody.NodesCollector;
import net.bull.javamelody.NodesController;
import net.bull.javamelody.PluginMonitoringFilter;

public class HudsonMonitoringFilter
extends PluginMonitoringFilter {
    private static final boolean PLUGIN_AUTHENTICATION_DISABLED = Boolean.parseBoolean(System.getProperty("javamelody.plugin-authentication-disabled"));
    private NodesCollector nodesCollector;

    public void init(FilterConfig config) throws ServletException {
        super.init(config);
        this.nodesCollector = new NodesCollector((MonitoringFilter)this);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse) || this.getNodesCollector().isMonitoringDisabled()) {
            super.doFilter(request, response, chain);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String requestURI = httpRequest.getRequestURI();
        String monitoringUrl = this.getMonitoringUrl(httpRequest);
        String monitoringSlavesUrl = monitoringUrl + "/nodes";
        if (!PLUGIN_AUTHENTICATION_DISABLED && (requestURI.equals(monitoringUrl) || requestURI.equals(monitoringSlavesUrl))) {
            Hudson.getInstance().checkPermission(Hudson.ADMINISTER);
        }
        if (requestURI.equals(monitoringSlavesUrl)) {
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            this.doMonitoring(httpRequest, httpResponse);
            return;
        }
        super.doFilter(request, response, chain);
    }

    private void doMonitoring(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
        if (NodesController.isJavaInformationsNeeded(httpRequest)) {
            this.getNodesCollector().collectWithoutErrors();
        }
        NodesController nodesController = new NodesController(this.getNodesCollector());
        nodesController.doMonitoring(httpRequest, httpResponse);
    }

    NodesCollector getNodesCollector() {
        return this.nodesCollector;
    }
}

