/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import hudson.model.Computer;
import hudson.model.Hudson;
import hudson.remoting.Callable;
import hudson.remoting.Future;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import net.bull.javamelody.Action;
import net.bull.javamelody.HeapHistogram;
import net.bull.javamelody.HtmlMBeansReport;
import net.bull.javamelody.I18N;
import net.bull.javamelody.JavaInformations;
import net.bull.javamelody.MBeans;
import net.bull.javamelody.ProcessInformations;
import net.bull.javamelody.VirtualMachine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RemoteCallHelper {
    private static final Callable<JavaInformations, Throwable> JAVA_INFORMATIONS_TASK = new Callable<JavaInformations, Throwable>(){
        private static final long serialVersionUID = 4778731836785411552L;

        public JavaInformations call() throws Throwable {
            JavaInformations.setWebXmlExistsAndPomXmlExists((boolean)false, (boolean)true);
            return new JavaInformations(null, true);
        }
    };
    private static final Callable<HeapHistogram, Throwable> HEAP_HISTOGRAM_TASK = new Callable<HeapHistogram, Throwable>(){
        private static final long serialVersionUID = -3978979765596110525L;

        public HeapHistogram call() throws Throwable {
            if (VirtualMachine.isSupported()) {
                return VirtualMachine.createHeapHistogram();
            }
            return null;
        }
    };
    private static final Callable<List<ProcessInformations>, Throwable> PROCESS_INFORMATIONS_TASK = new Callable<List<ProcessInformations>, Throwable>(){
        private static final long serialVersionUID = -4653173833541398792L;

        public List<ProcessInformations> call() throws Throwable {
            return ProcessInformations.buildProcessInformations();
        }
    };
    private static final Callable<String, Throwable> MBEANS_HTML_TASK = new Callable<String, Throwable>(){
        private static final long serialVersionUID = 7010512609895185019L;

        public String call() throws Throwable {
            StringWriter writer = new StringWriter();
            new HtmlMBeansReport((Writer)writer).writeTree();
            return writer.toString();
        }
    };

    private RemoteCallHelper() {
    }

    private static <T> Map<String, T> collectDataByNodeName(Callable<T, Throwable> task) throws IOException, InterruptedException, ExecutionException {
        Computer[] computers = Hudson.getInstance().getComputers();
        LinkedHashMap<String, Future> futuresByNodeName = new LinkedHashMap<String, Future>(computers.length);
        DelegatingTask<T> delegatingTask = new DelegatingTask<T>(task);
        for (Computer c : computers) {
            if (!c.isOnline()) continue;
            futuresByNodeName.put(c.getName(), c.getChannel().callAsync(delegatingTask));
        }
        LinkedHashMap result = new LinkedHashMap(futuresByNodeName.size());
        for (Map.Entry entry : futuresByNodeName.entrySet()) {
            result.put(entry.getKey(), ((Future)entry.getValue()).get());
        }
        return result;
    }

    static List<JavaInformations> collectJavaInformationsList() throws IOException, InterruptedException, ExecutionException {
        Map<String, JavaInformations> javaInformationsByNodeName = RemoteCallHelper.collectDataByNodeName(JAVA_INFORMATIONS_TASK);
        return new ArrayList<JavaInformations>(javaInformationsByNodeName.values());
    }

    static List<String> collectJmxValues(String jmxValueParameter) throws IOException, InterruptedException, ExecutionException {
        return new ArrayList<String>(RemoteCallHelper.collectDataByNodeName(new JmxValueTask(jmxValueParameter)).values());
    }

    static Map<String, String> collectMBeansHtmlInformations() throws IOException, InterruptedException, ExecutionException {
        return RemoteCallHelper.collectDataByNodeName(MBEANS_HTML_TASK);
    }

    static Map<String, List<ProcessInformations>> collectProcessInformationsByNodeName() throws IOException, InterruptedException, ExecutionException {
        return RemoteCallHelper.collectDataByNodeName(PROCESS_INFORMATIONS_TASK);
    }

    static HeapHistogram collectGlobalHeapHistogram() throws IOException, InterruptedException, ExecutionException {
        Map<String, HeapHistogram> heapHistograms = RemoteCallHelper.collectDataByNodeName(HEAP_HISTOGRAM_TASK);
        HeapHistogram heapHistoTotal = null;
        for (HeapHistogram heapHisto : heapHistograms.values()) {
            if (heapHistoTotal == null) {
                heapHistoTotal = heapHisto;
                continue;
            }
            if (heapHisto == null) continue;
            heapHistoTotal.add(heapHisto);
        }
        if (heapHistoTotal == null) {
            throw new IllegalStateException(I18N.getString((String)"heap_histo_non_supporte"));
        }
        return heapHistoTotal;
    }

    static String forwardAction(String actionName, String sessionId, String threadId, String jobId) throws IOException, InterruptedException, ExecutionException {
        ActionTask task = new ActionTask(actionName, sessionId, threadId, jobId);
        Map<String, String> messagesByNodeName = RemoteCallHelper.collectDataByNodeName(task);
        StringBuilder sb = new StringBuilder();
        for (String messageForReport : messagesByNodeName.values()) {
            if (messageForReport == null) continue;
            sb.append(messageForReport).append('\n');
        }
        String messageForReport = sb.length() == 0 ? null : sb.toString();
        return messageForReport;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DelegatingTask<T>
    implements Callable<T, Throwable> {
        private static final long serialVersionUID = -8596757920851396797L;
        private final Callable<T, Throwable> delegate;
        private final Locale locale;

        DelegatingTask(Callable<T, Throwable> delegate) {
            this.delegate = delegate;
            this.locale = I18N.getCurrentLocale();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T call() throws Throwable {
            I18N.bindLocale((Locale)this.locale);
            try {
                Object object = this.delegate.call();
                return (T)object;
            }
            finally {
                I18N.unbindLocale();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JmxValueTask
    implements Callable<String, Throwable> {
        private static final long serialVersionUID = -4654080667819214726L;
        private final String jmxValueParameter;

        JmxValueTask(String jmxValueParameter) {
            this.jmxValueParameter = jmxValueParameter;
        }

        public String call() throws Throwable {
            return MBeans.getConvertedAttributes((String)this.jmxValueParameter);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ActionTask
    implements Callable<String, Throwable> {
        private static final long serialVersionUID = -3978979765596110525L;
        private final String actionName;
        private final String sessionId;
        private final String threadId;
        private final String jobId;

        ActionTask(String actionName, String sessionId, String threadId, String jobId) {
            this.actionName = actionName;
            this.sessionId = sessionId;
            this.threadId = threadId;
            this.jobId = jobId;
        }

        public String call() throws Throwable {
            Action action = Action.valueOfIgnoreCase((String)this.actionName);
            return action.execute(null, null, null, this.sessionId, this.threadId, this.jobId);
        }
    }
}

