/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import hudson.model.Hudson;
import java.util.Collections;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import net.bull.javamelody.Collector;
import net.bull.javamelody.Counter;
import net.bull.javamelody.CounterRunListener;
import net.bull.javamelody.JavaInformations;
import net.bull.javamelody.JdbcWrapper;
import net.bull.javamelody.LOG;
import net.bull.javamelody.MailReport;
import net.bull.javamelody.MonitoringFilter;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.Parameters;
import net.bull.javamelody.Period;
import net.bull.javamelody.RemoteCallHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodesCollector {
    private final boolean monitoringDisabled = Boolean.parseBoolean(Parameters.getParameter((Parameter)Parameter.DISABLED));
    private final Timer timer;
    private final Collector collector;
    private List<JavaInformations> lastJavaInformationsList;

    public NodesCollector(MonitoringFilter filter) {
        if (!this.monitoringDisabled) {
            this.timer = filter.getFilterContext().getTimer();
            List<Counter> counters = Collections.singletonList(CounterRunListener.getBuildCounter());
            this.collector = new RemoteCollector("nodes", counters);
        } else {
            this.timer = null;
            this.collector = null;
        }
    }

    public void init() {
        if (this.monitoringDisabled) {
            return;
        }
        int periodMillis = Parameters.getResolutionSeconds() * 1000;
        TimerTask collectTask = new TimerTask(){

            public void run() {
                NodesCollector.this.collectWithoutErrors();
            }
        };
        this.timer.schedule(collectTask, 5000L, (long)periodMillis);
        if (Parameters.getParameter((Parameter)Parameter.MAIL_SESSION) != null && Parameters.getParameter((Parameter)Parameter.ADMIN_EMAILS) != null) {
            this.scheduleReportMailForSlaves();
        }
    }

    public void scheduleCollectNow() {
        if (this.monitoringDisabled) {
            return;
        }
        TimerTask collectTask = new TimerTask(){

            public void run() {
                NodesCollector.this.collectWithoutErrors();
            }
        };
        this.timer.schedule(collectTask, 0L);
    }

    public void stop() {
        if (this.monitoringDisabled) {
            return;
        }
        this.timer.cancel();
        this.collector.stop();
    }

    public void collectWithoutErrors() {
        try {
            this.lastJavaInformationsList = RemoteCallHelper.collectJavaInformationsList();
            int queueLength = Hudson.getInstance().getQueue().getBuildableItems().size();
            JdbcWrapper.BUILD_QUEUE_LENGTH.set(queueLength);
            this.collector.collectWithoutErrors(this.lastJavaInformationsList);
        }
        catch (Throwable t) {
            LOG.warn((String)"exception while collecting data", (Throwable)t);
        }
    }

    private void scheduleReportMailForSlaves() {
        for (Period period : MailReport.getMailPeriods()) {
            this.scheduleReportMailForSlaves(period);
        }
    }

    void scheduleReportMailForSlaves(final Period period) {
        assert (period != null);
        TimerTask task = new TimerTask(){

            public void run() {
                try {
                    new MailReport().sendReportMail(NodesCollector.this.getCollector(), true, NodesCollector.this.getLastJavaInformationsList(), period);
                }
                catch (Throwable t) {
                    LOG.warn((String)"sending mail report failed", (Throwable)t);
                }
                NodesCollector.this.scheduleReportMailForSlaves(period);
            }
        };
        this.timer.schedule(task, MailReport.getNextExecutionDate((Period)period));
    }

    Collector getCollector() {
        return this.collector;
    }

    List<JavaInformations> getLastJavaInformationsList() {
        return this.lastJavaInformationsList;
    }

    public boolean isMonitoringDisabled() {
        return this.monitoringDisabled;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RemoteCollector
    extends Collector {
        RemoteCollector(String application, List<Counter> counters) {
            super(application, counters);
        }

        void collectLocalContextWithoutErrors() {
        }
    }
}

