/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.bull.javamelody.Action;
import net.bull.javamelody.Collector;
import net.bull.javamelody.CompressionServletResponseWrapper;
import net.bull.javamelody.HeapHistogram;
import net.bull.javamelody.HtmlProcessInformationsReport;
import net.bull.javamelody.HtmlReport;
import net.bull.javamelody.HttpCookieManager;
import net.bull.javamelody.I18N;
import net.bull.javamelody.JavaInformations;
import net.bull.javamelody.MonitoringController;
import net.bull.javamelody.NodesCollector;
import net.bull.javamelody.PdfOtherReport;
import net.bull.javamelody.Period;
import net.bull.javamelody.ProcessInformations;
import net.bull.javamelody.Range;
import net.bull.javamelody.RemoteCallHelper;
import net.bull.javamelody.TransportFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodesController {
    private final Collector collector;
    private final List<JavaInformations> lastJavaInformationsList;
    private final HttpCookieManager httpCookieManager = new HttpCookieManager();

    public NodesController(NodesCollector nodesCollector) {
        this.collector = nodesCollector.getCollector();
        this.lastJavaInformationsList = nodesCollector.getLastJavaInformationsList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doMonitoring(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (this.lastJavaInformationsList != null && !this.lastJavaInformationsList.isEmpty()) {
            try {
                I18N.bindLocale((Locale)req.getLocale());
                MonitoringController monitoringController = new MonitoringController(this.collector, null);
                String partParameter = req.getParameter("part");
                String actionParameter = req.getParameter("action");
                if (actionParameter != null) {
                    if (Action.valueOfIgnoreCase((String)actionParameter) != Action.CLEAR_COUNTER) {
                        String actionName = req.getParameter("action");
                        String sessionId = req.getParameter("sessionId");
                        String threadId = req.getParameter("threadId");
                        String jobId = req.getParameter("jobId");
                        String messageForReport = RemoteCallHelper.forwardAction(actionName, sessionId, threadId, jobId);
                        this.writeMessage(resp, messageForReport, partParameter);
                    } else {
                        String messageForReport = monitoringController.executeActionIfNeeded(req);
                        this.writeMessage(resp, messageForReport, null);
                    }
                    return;
                }
                String formatParameter = req.getParameter("format");
                if (req.getParameter("jmxValue") != null) {
                    List<String> jmxValues = RemoteCallHelper.collectJmxValues(req.getParameter("jmxValue"));
                    this.doJmxValue(resp, jmxValues);
                }
                if (TransportFormat.isATransportFormat((String)req.getParameter("format"))) {
                    this.doCompressedSerializable(req, resp, monitoringController);
                }
                if ("pdf".equalsIgnoreCase(formatParameter)) {
                    this.doPdf(req, resp, monitoringController);
                }
                if (partParameter == null) {
                    monitoringController.doReport(req, resp, this.lastJavaInformationsList);
                }
                this.doCompressedPart(req, resp, monitoringController, partParameter);
            }
            catch (Exception e) {
                this.writeMessage(resp, e.getMessage(), null);
            }
            finally {
                I18N.unbindLocale();
            }
        } else {
            MonitoringController.noCache((HttpServletResponse)resp);
            PrintWriter writer = resp.getWriter();
            writer.write("<html><body>");
            writer.write("<a href='javascript:history.back()'>Back</a>");
            writer.write("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
            writer.write("<a href='?'>Update</a>");
            writer.write("<br/><br/>No slaves online, try again in a minute.");
            writer.write("</body></html>");
            writer.close();
        }
    }

    private void writeMessage(HttpServletResponse resp, String message, String partToRedirectTo) throws IOException {
        MonitoringController.noCache((HttpServletResponse)resp);
        PrintWriter writer = NodesController.createWriterFromOutputStream(resp);
        new HtmlReport(this.collector, null, this.lastJavaInformationsList, Period.TOUT, (Writer)writer).writeMessageIfNotNull(message, partToRedirectTo);
        writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPdf(HttpServletRequest req, HttpServletResponse resp, MonitoringController monitoringController) throws IOException, InterruptedException, ExecutionException {
        if ("processes".equalsIgnoreCase(req.getParameter("part"))) {
            monitoringController.addPdfContentTypeAndDisposition(req, resp);
            try {
                this.doPdfProcesses(resp);
            }
            finally {
                resp.getOutputStream().flush();
            }
        } else {
            monitoringController.doReport(req, resp, this.lastJavaInformationsList);
        }
    }

    private void doPdfProcesses(HttpServletResponse resp) throws IOException, InterruptedException, ExecutionException {
        Map<String, List<ProcessInformations>> processInformationsByNodeName = RemoteCallHelper.collectProcessInformationsByNodeName();
        String title = I18N.getString((String)"Processus");
        LinkedHashMap<String, List<ProcessInformations>> processInformationsByTitle = new LinkedHashMap<String, List<ProcessInformations>>();
        for (Map.Entry<String, List<ProcessInformations>> entry : processInformationsByNodeName.entrySet()) {
            processInformationsByTitle.put(title + " (" + entry.getKey() + ')', entry.getValue());
        }
        new PdfOtherReport(this.collector.getApplication(), (OutputStream)resp.getOutputStream()).writeProcessInformations(processInformationsByTitle);
    }

    private void doJmxValue(HttpServletResponse resp, List<String> jmxValues) throws IOException {
        MonitoringController.noCache((HttpServletResponse)resp);
        resp.setContentType("text/plain");
        PrintWriter writer = resp.getWriter();
        boolean first = true;
        for (String jmxValue : jmxValues) {
            if (first) {
                first = false;
            } else {
                writer.write(124);
                writer.write(124);
            }
            writer.write(jmxValue);
        }
        writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCompressedPart(HttpServletRequest httpRequest, HttpServletResponse httpResponse, MonitoringController monitoringController, String partParameter) throws IOException, InterruptedException, ExecutionException {
        if (MonitoringController.isCompressionSupported((HttpServletRequest)httpRequest)) {
            CompressionServletResponseWrapper wrappedResponse = new CompressionServletResponseWrapper(httpResponse, 4096);
            try {
                this.doPart(httpRequest, (HttpServletResponse)wrappedResponse, monitoringController, partParameter);
            }
            finally {
                wrappedResponse.finishResponse();
            }
        } else {
            this.doPart(httpRequest, httpResponse, monitoringController, partParameter);
        }
    }

    private void doPart(HttpServletRequest req, HttpServletResponse resp, MonitoringController monitoringController, String partParameter) throws IOException, InterruptedException, ExecutionException {
        if ("mbeans".equalsIgnoreCase(partParameter)) {
            Map<String, String> mbeansHtmlInformations = RemoteCallHelper.collectMBeansHtmlInformations();
            this.doMBeans(req, resp, mbeansHtmlInformations);
        } else if ("processes".equalsIgnoreCase(partParameter)) {
            Map<String, List<ProcessInformations>> processInformationsByNodeName = RemoteCallHelper.collectProcessInformationsByNodeName();
            this.doProcesses(req, resp, processInformationsByNodeName);
        } else if ("heaphisto".equalsIgnoreCase(partParameter)) {
            HeapHistogram heapHistoTotal = RemoteCallHelper.collectGlobalHeapHistogram();
            this.doHeapHisto(req, resp, heapHistoTotal, monitoringController);
        } else {
            monitoringController.doReport(req, resp, this.lastJavaInformationsList);
        }
    }

    private void doProcesses(HttpServletRequest req, HttpServletResponse resp, Map<String, List<ProcessInformations>> processListByNodeName) throws IOException {
        PrintWriter writer = NodesController.createWriterFromOutputStream(resp);
        HtmlReport htmlReport = this.createHtmlReport(req, resp, writer);
        htmlReport.writeHtmlHeader();
        writer.write("<div class='noPrint'>");
        I18N.writelnTo((String)"<a href='javascript:history.back()'><img src='?resource=action_back.png' alt='#Retour#'/> #Retour#</a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;", (Writer)writer);
        writer.write("<a href='?part=");
        writer.write("processes");
        writer.write("'>");
        I18N.writelnTo((String)"<img src='?resource=action_refresh.png' alt='#Actualiser#'/> #Actualiser#</a>", (Writer)writer);
        writer.write("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        I18N.writelnTo((String)"<a href='?part=processes&amp;format=pdf' title='#afficher_PDF#'>", (Writer)writer);
        I18N.writelnTo((String)"<img src='?resource=pdf.png' alt='#PDF#'/> #PDF#</a>", (Writer)writer);
        writer.write("</div>");
        String title = I18N.getString((String)"Processus");
        for (Map.Entry<String, List<ProcessInformations>> entry : processListByNodeName.entrySet()) {
            String htmlTitle = "<h3><img width='24' height='24' src='?resource=processes.png' alt='" + title + "'/>&nbsp;" + title + " (" + I18N.htmlEncode((String)entry.getKey(), (boolean)false) + ")</h3>";
            writer.write(htmlTitle);
            writer.flush();
            new HtmlProcessInformationsReport(entry.getValue(), (Writer)writer).writeTable();
        }
        htmlReport.writeHtmlFooter();
        writer.close();
    }

    private void doMBeans(HttpServletRequest req, HttpServletResponse resp, Map<String, String> mbeansHtmlInformations) throws IOException {
        PrintWriter writer = NodesController.createWriterFromOutputStream(resp);
        HtmlReport htmlReport = this.createHtmlReport(req, resp, writer);
        htmlReport.writeHtmlHeader();
        writer.write("<div class='noPrint'>");
        I18N.writelnTo((String)"<a href='javascript:history.back()'><img src='?resource=action_back.png' alt='#Retour#'/> #Retour#</a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;", (Writer)writer);
        writer.write("<a href='?part=");
        writer.write("mbeans");
        writer.write("'>");
        I18N.writelnTo((String)"<img src='?resource=action_refresh.png' alt='#Actualiser#'/> #Actualiser#", (Writer)writer);
        writer.write("</a></div>");
        String title = I18N.getString((String)"MBeans");
        for (Map.Entry<String, String> entry : mbeansHtmlInformations.entrySet()) {
            String htmlTitle = "<h3><img width='24' height='24' src='?resource=mbeans.png' alt='" + title + "'/>&nbsp;" + title + " (" + I18N.htmlEncode((String)entry.getKey(), (boolean)false) + ")</h3>";
            writer.write(htmlTitle);
            writer.write(entry.getValue());
        }
        htmlReport.writeHtmlFooter();
        writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doHeapHisto(HttpServletRequest req, HttpServletResponse resp, HeapHistogram heapHistogram, MonitoringController monitoringController) throws IOException {
        if ("pdf".equalsIgnoreCase(req.getParameter("format"))) {
            monitoringController.addPdfContentTypeAndDisposition(req, resp);
            try {
                PdfOtherReport pdfOtherReport = new PdfOtherReport(this.collector.getApplication(), (OutputStream)resp.getOutputStream());
                pdfOtherReport.writeHeapHistogram(heapHistogram);
            }
            finally {
                resp.getOutputStream().flush();
            }
        } else {
            PrintWriter writer = NodesController.createWriterFromOutputStream(resp);
            HtmlReport htmlReport = this.createHtmlReport(req, resp, writer);
            htmlReport.writeHtmlHeader();
            htmlReport.writeHeapHistogram(heapHistogram, null, "heaphisto");
            htmlReport.writeHtmlFooter();
            writer.close();
        }
    }

    private void doCompressedSerializable(HttpServletRequest httpRequest, HttpServletResponse httpResponse, MonitoringController monitoringController) throws IOException {
        Serializable serializable;
        try {
            serializable = this.createSerializable(httpRequest, monitoringController);
        }
        catch (Exception e) {
            serializable = e;
        }
        monitoringController.doCompressedSerializable(httpRequest, httpResponse, serializable);
    }

    private Serializable createSerializable(HttpServletRequest httpRequest, MonitoringController monitoringController) throws Exception {
        String part = httpRequest.getParameter("part");
        if ("heaphisto".equalsIgnoreCase(part)) {
            return RemoteCallHelper.collectGlobalHeapHistogram();
        }
        if ("processes".equalsIgnoreCase(part)) {
            return new LinkedHashMap<String, List<ProcessInformations>>(RemoteCallHelper.collectProcessInformationsByNodeName());
        }
        if ("threads".equalsIgnoreCase(part)) {
            ArrayList result = new ArrayList();
            for (JavaInformations javaInformations : this.lastJavaInformationsList) {
                result.add(new ArrayList(javaInformations.getThreadInformationsList()));
            }
            return result;
        }
        Range range = monitoringController.getRangeForSerializable(httpRequest);
        return monitoringController.createDefaultSerializable(this.lastJavaInformationsList, range);
    }

    private HtmlReport createHtmlReport(HttpServletRequest req, HttpServletResponse resp, PrintWriter writer) {
        Range range = this.httpCookieManager.getRange(req, resp);
        return new HtmlReport(this.collector, null, this.lastJavaInformationsList, range, (Writer)writer);
    }

    private static PrintWriter createWriterFromOutputStream(HttpServletResponse httpResponse) throws IOException {
        MonitoringController.noCache((HttpServletResponse)httpResponse);
        httpResponse.setContentType("text/html; charset=UTF-8");
        return new PrintWriter(MonitoringController.getWriter((HttpServletResponse)httpResponse));
    }

    public static boolean isJavaInformationsNeeded(HttpServletRequest httpRequest) {
        return MonitoringController.isJavaInformationsNeeded((HttpServletRequest)httpRequest);
    }
}

