/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import hudson.model.AbstractBuild;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import net.bull.javamelody.Counter;
import net.bull.javamelody.JdbcWrapper;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CounterRunListener
extends RunListener<AbstractBuild> {
    private static final Counter BUILD_COUNTER = new Counter("builds", "jobs.png");
    private static final boolean COUNTER_HIDDEN = Parameters.isCounterHidden((String)BUILD_COUNTER.getName());
    private static final boolean DISABLED = Boolean.parseBoolean(Parameters.getParameter((Parameter)Parameter.DISABLED));

    public CounterRunListener() {
        super(AbstractBuild.class);
        BUILD_COUNTER.setDisplayed(!COUNTER_HIDDEN);
    }

    static Counter getBuildCounter() {
        return BUILD_COUNTER;
    }

    public void onStarted(AbstractBuild r, TaskListener listener) {
        super.onStarted((Run)r, listener);
        if (DISABLED || !BUILD_COUNTER.isDisplayed()) {
            return;
        }
        String name = r.getProject().getName();
        BUILD_COUNTER.bindContextIncludingCpu(name);
        JdbcWrapper.RUNNING_BUILD_COUNT.incrementAndGet();
    }

    public void onCompleted(AbstractBuild r, TaskListener listener) {
        super.onCompleted((Run)r, listener);
        if (DISABLED || !BUILD_COUNTER.isDisplayed()) {
            return;
        }
        JdbcWrapper.RUNNING_BUILD_COUNT.decrementAndGet();
        boolean error = Result.FAILURE.equals(r.getResult());
        BUILD_COUNTER.addRequestForCurrentContext(error);
    }
}

