/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ircbot.steps;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.im.MatrixJobMultiplier;
import hudson.plugins.im.NotificationStrategy;
import hudson.plugins.im.build_notify.BuildToChatNotifier;
import hudson.plugins.im.build_notify.DefaultBuildToChatNotifier;
import hudson.plugins.ircbot.IrcPublisher;
import hudson.plugins.ircbot.v2.IRCMessageTargetConverter;
import hudson.util.ListBoxModel;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class IrcNotifyStep
extends Step {
    private static final long serialVersionUID = 2L;
    private static final char TARGET_SEPARATOR_CHAR = ' ';
    private static final IRCMessageTargetConverter CONVERTER = new IRCMessageTargetConverter();
    private String targets = "";
    private boolean notifyOnStart = false;
    private boolean notifySuspects;
    private boolean notifyCulprits;
    private boolean notifyFixers;
    private boolean notifyUpstreamCommitters;
    private String notificationStrategy = NotificationStrategy.ALL.getDisplayName();
    private BuildToChatNotifier buildToChatNotifier = new DefaultBuildToChatNotifier();
    private MatrixJobMultiplier matrixNotifier = MatrixJobMultiplier.ONLY_PARENT;
    private String extraMessage;
    private String customMessage;

    public StepExecution start(StepContext context) throws Exception {
        return new IrcNotifyStepExecution(this, context);
    }

    @DataBoundConstructor
    public IrcNotifyStep() {
    }

    @DataBoundSetter
    public void setTargets(String targets) {
        this.targets = targets;
    }

    public String getTargets() {
        return this.targets;
    }

    public boolean isNotifyOnStart() {
        return this.notifyOnStart;
    }

    @DataBoundSetter
    public void setNotifyOnStart(boolean notifyOnStart) {
        this.notifyOnStart = notifyOnStart;
    }

    public boolean isNotifySuspects() {
        return this.notifySuspects;
    }

    @DataBoundSetter
    public void setNotifySuspects(boolean notifySuspects) {
        this.notifySuspects = notifySuspects;
    }

    public boolean isNotifyCulprits() {
        return this.notifyCulprits;
    }

    @DataBoundSetter
    public void setNotifyCulprits(boolean notifyCulprits) {
        this.notifyCulprits = notifyCulprits;
    }

    public boolean isNotifyFixers() {
        return this.notifyFixers;
    }

    @DataBoundSetter
    public void setNotifyFixers(boolean notifyFixers) {
        this.notifyFixers = notifyFixers;
    }

    public boolean isNotifyUpstreamCommitters() {
        return this.notifyUpstreamCommitters;
    }

    @DataBoundSetter
    public void setNotifyUpstreamCommitters(boolean notifyUpstreamCommitters) {
        this.notifyUpstreamCommitters = notifyUpstreamCommitters;
    }

    public BuildToChatNotifier getBuildToChatNotifier() {
        return this.buildToChatNotifier;
    }

    @DataBoundSetter
    public void setBuildToChatNotifier(BuildToChatNotifier buildToChatNotifier) {
        this.buildToChatNotifier = buildToChatNotifier;
    }

    public MatrixJobMultiplier getMatrixNotifier() {
        return this.matrixNotifier;
    }

    @DataBoundSetter
    public void setMatrixNotifier(MatrixJobMultiplier matrixNotifier) {
        this.matrixNotifier = matrixNotifier;
    }

    public String getNotificationStrategy() {
        return this.notificationStrategy;
    }

    @DataBoundSetter
    public void setNotificationStrategy(String notificationStrategy) {
        this.notificationStrategy = notificationStrategy;
    }

    public String getExtraMessage() {
        return this.extraMessage;
    }

    @DataBoundSetter
    public void setExtraMessage(String extraMessage) {
        this.extraMessage = extraMessage;
    }

    public String getCustomMessage() {
        return this.customMessage;
    }

    @DataBoundSetter
    public void setCustomMessage(String customMessage) {
        this.customMessage = customMessage;
    }

    private static class IrcNotifyStepExecution
    extends SynchronousNonBlockingStepExecution<Void> {
        private static final long serialVersionUID = 2L;
        @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
        private final transient IrcNotifyStep step;

        public IrcNotifyStepExecution(@NonNull IrcNotifyStep step, @NonNull StepContext context) {
            super(context);
            this.step = step;
        }

        protected Void run() throws Exception {
            IrcPublisher publisher = new IrcPublisher(this.step.targets.equals("") ? IrcPublisher.DESCRIPTOR.getDefaultTargets() : CONVERTER.allFromString(Arrays.asList(StringUtils.split((String)this.step.targets, (char)' '))), this.step.notificationStrategy, this.step.notifyOnStart, this.step.notifySuspects, this.step.notifyCulprits, this.step.notifyFixers, this.step.notifyUpstreamCommitters, this.step.buildToChatNotifier, this.step.matrixNotifier);
            publisher.setExtraMessage(this.step.extraMessage);
            publisher.setCustomMessage(this.step.customMessage);
            publisher.perform((Run)this.getContext().get(Run.class), (FilePath)this.getContext().get(FilePath.class), (Launcher)this.getContext().get(Launcher.class), (TaskListener)this.getContext().get(TaskListener.class));
            return null;
        }
    }

    @Extension(optional=true)
    public static final class DescriptorImpl
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            HashSet context = new HashSet();
            Collections.addAll(context, FilePath.class, Run.class, Launcher.class, TaskListener.class);
            return Collections.unmodifiableSet(context);
        }

        public String getFunctionName() {
            return "ircNotify";
        }

        public String getDisplayName() {
            return "IRC Notification";
        }

        public ListBoxModel doFillNotificationStrategyItems() {
            ListBoxModel items = new ListBoxModel();
            for (NotificationStrategy strategy : NotificationStrategy.values()) {
                items.add(strategy.getDisplayName(), strategy.getDisplayName());
            }
            return items;
        }
    }
}

