/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.im.build_notify;

import hudson.DescriptorExtensionList;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Describable;
import hudson.model.Hudson;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.im.IMPublisher;
import hudson.plugins.im.build_notify.BuildToChatNotifierDescriptor;
import hudson.plugins.im.tools.BuildHelper;
import hudson.plugins.im.tools.MessageHelper;
import java.io.IOException;

public abstract class BuildToChatNotifier
implements Describable<BuildToChatNotifier> {
    public abstract String buildStartMessage(IMPublisher var1, AbstractBuild<?, ?> var2, BuildListener var3) throws IOException, InterruptedException;

    public abstract String buildStartMessage(IMPublisher var1, Run<?, ?> var2, TaskListener var3) throws IOException, InterruptedException;

    public abstract String buildCompletionMessage(IMPublisher var1, Run<?, ?> var2, TaskListener var3) throws IOException, InterruptedException;

    public String suspectMessage(IMPublisher publisher, Run<?, ?> run, TaskListener listener, boolean firstFailure) {
        if (firstFailure) {
            return "Oh no! You're suspected of having broken " + BuildHelper.getProjectName(run) + ": " + MessageHelper.getBuildURL(run);
        }
        return "Build " + BuildHelper.getProjectName(run) + " is " + BuildHelper.getResultTrend(run).getID() + ": " + MessageHelper.getBuildURL(run);
    }

    public String culpritMessage(IMPublisher publisher, Run<?, ?> run, TaskListener listener) {
        return "You're still being suspected of having broken " + BuildHelper.getProjectName(run) + ": " + MessageHelper.getBuildURL(run);
    }

    public String fixerMessage(IMPublisher publisher, Run<?, ?> run, TaskListener listener) {
        return "Yippee! Seems you've fixed " + BuildHelper.getProjectName(run) + ": " + MessageHelper.getBuildURL(run);
    }

    public String upstreamCommitterMessage(IMPublisher publisher, Run<?, ?> run, TaskListener listener, Run<?, ?> upstreamBuild) {
        return "Attention! Your change in " + BuildHelper.getProjectName(upstreamBuild) + ": " + MessageHelper.getBuildURL(upstreamBuild) + " *might* have broken the downstream job " + BuildHelper.getProjectName(run) + ": " + MessageHelper.getBuildURL(run) + "\nPlease have a look!";
    }

    public BuildToChatNotifierDescriptor getDescriptor() {
        return (BuildToChatNotifierDescriptor)Hudson.getInstance().getDescriptorOrDie(this.getClass());
    }

    public static DescriptorExtensionList<BuildToChatNotifier, BuildToChatNotifierDescriptor> all() {
        return Hudson.getInstance().getDescriptorList(BuildToChatNotifier.class);
    }
}

