/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.im;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.plugins.im.IMMessageTarget;
import hudson.util.Secret;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class GroupChatIMMessageTarget
implements IMMessageTarget {
    private static final long serialVersionUID = 1L;
    @Deprecated
    private transient String value;
    private String name;
    private Secret password;
    @Deprecated
    private transient Secret secretPassword;
    private final boolean notificationOnly;

    @Deprecated
    public GroupChatIMMessageTarget(String name) {
        this(name, (Secret)null, false);
    }

    @Deprecated
    public GroupChatIMMessageTarget(String name, String password, boolean notificationOnly) {
        Objects.requireNonNull(name, "Parameter 'name' must not be null.");
        this.name = name;
        this.password = Secret.fromString((String)password);
        this.notificationOnly = notificationOnly;
    }

    public GroupChatIMMessageTarget(String name, Secret secretPassword, boolean notificationOnly) {
        Objects.requireNonNull(name, "Parameter 'name' must not be null.");
        this.name = name;
        this.password = secretPassword;
        this.notificationOnly = notificationOnly;
    }

    @DataBoundConstructor
    public GroupChatIMMessageTarget(String name, boolean notificationOnly) {
        Objects.requireNonNull(name, "Parameter 'name' must not be null.");
        this.name = name;
        this.notificationOnly = notificationOnly;
    }

    public String getName() {
        return this.name;
    }

    @Deprecated
    public String getPassword() {
        return Secret.toString((Secret)this.password);
    }

    public Secret getSecretPassword() {
        return this.password;
    }

    @DataBoundSetter
    public void setSecretPassword(Secret secretPassword) {
        this.password = Secret.toString((Secret)secretPassword).equals("") ? null : secretPassword;
    }

    public boolean hasPassword() {
        return this.password != null && StringUtils.isNotBlank((String)this.password.getPlainText());
    }

    public boolean isNotificationOnly() {
        return this.notificationOnly;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupChatIMMessageTarget that = (GroupChatIMMessageTarget)o;
        return this.notificationOnly == that.notificationOnly && Objects.equals(this.value, that.value) && Objects.equals(this.name, that.name) && Objects.equals(this.password, that.password);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.name, this.password, this.notificationOnly);
    }

    public String toString() {
        return this.name;
    }

    protected Object readResolve() {
        if (this.value != null && this.name == null) {
            this.name = this.value;
        }
        if (this.secretPassword != null) {
            this.password = this.secretPassword;
            this.secretPassword = null;
        }
        this.value = null;
        return this;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<IMMessageTarget> {
        public String getDisplayName() {
            return "groupChatIMMessageTarget";
        }
    }
}

