// CHECKSTYLE:OFF

package hudson.plugins.im.build_notify;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code SummaryOnlyBuildToChatNotifier.StartMessage}: {@code
     * Starting build {0} for job {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Starting build {0} for job {1}}
     */
    public static String SummaryOnlyBuildToChatNotifier_StartMessage(Object arg0, Object arg1) {
        return holder.format("SummaryOnlyBuildToChatNotifier.StartMessage", arg0, arg1);
    }

    /**
     * Key {@code SummaryOnlyBuildToChatNotifier.StartMessage}: {@code
     * Starting build {0} for job {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Starting build {0} for job {1}}
     */
    public static Localizable _SummaryOnlyBuildToChatNotifier_StartMessage(Object arg0, Object arg1) {
        return new Localizable(holder, "SummaryOnlyBuildToChatNotifier.StartMessage", arg0, arg1);
    }

    /**
     * Key {@code SummaryOnlyBuildToChatNotifier.BuildIsFixed}: {@code
     * Yippee, build fixed!
     * }.
     * 
     * @return
     *     {@code Yippee, build fixed!
     *     }
     */
    public static String SummaryOnlyBuildToChatNotifier_BuildIsFixed() {
        return holder.format("SummaryOnlyBuildToChatNotifier.BuildIsFixed");
    }

    /**
     * Key {@code SummaryOnlyBuildToChatNotifier.BuildIsFixed}: {@code
     * Yippee, build fixed!
     * }.
     * 
     * @return
     *     {@code Yippee, build fixed!
     *     }
     */
    public static Localizable _SummaryOnlyBuildToChatNotifier_BuildIsFixed() {
        return new Localizable(holder, "SummaryOnlyBuildToChatNotifier.BuildIsFixed");
    }

    /**
     * Key {@code SummaryOnlyBuildToChatNotifier.Summary}: {@code Project {0}
     * build {1}: {2} in {3}: {4}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, as {@link String#valueOf(Object)}.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg4
     *      5th format parameter, {@code {4}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Project {0} build {1}: {2} in {3}: {4}}
     */
    public static String SummaryOnlyBuildToChatNotifier_Summary(Object arg0, Object arg1, Object arg2, Object arg3, Object arg4) {
        return holder.format("SummaryOnlyBuildToChatNotifier.Summary", arg0, arg1, arg2, arg3, arg4);
    }

    /**
     * Key {@code SummaryOnlyBuildToChatNotifier.Summary}: {@code Project {0}
     * build {1}: {2} in {3}: {4}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, as {@link String#valueOf(Object)}.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg4
     *      5th format parameter, {@code {4}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Project {0} build {1}: {2} in {3}: {4}}
     */
    public static Localizable _SummaryOnlyBuildToChatNotifier_Summary(Object arg0, Object arg1, Object arg2, Object arg3, Object arg4) {
        return new Localizable(holder, "SummaryOnlyBuildToChatNotifier.Summary", arg0, arg1, arg2, arg3, arg4);
    }

    /**
     * Key {@code SummaryOnlyBuildToChatNotifier.StartMessageExtra}: {@code
     * Starting build {0} for job {1} {2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Starting build {0} for job {1} {2}}
     */
    public static String SummaryOnlyBuildToChatNotifier_StartMessageExtra(Object arg0, Object arg1, Object arg2) {
        return holder.format("SummaryOnlyBuildToChatNotifier.StartMessageExtra", arg0, arg1, arg2);
    }

    /**
     * Key {@code SummaryOnlyBuildToChatNotifier.StartMessageExtra}: {@code
     * Starting build {0} for job {1} {2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Starting build {0} for job {1} {2}}
     */
    public static Localizable _SummaryOnlyBuildToChatNotifier_StartMessageExtra(Object arg0, Object arg1, Object arg2) {
        return new Localizable(holder, "SummaryOnlyBuildToChatNotifier.StartMessageExtra", arg0, arg1, arg2);
    }

    /**
     * Key {@code SummaryOnlyBuildToChatNotifier.SummaryExtra}: {@code
     * Project {0} build {1}: {2} in {3}: {4} {5}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, as {@link String#valueOf(Object)}.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg5
     *      6th format parameter, {@code {5}}, as {@link String#valueOf(Object)}.
     * @param arg4
     *      5th format parameter, {@code {4}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Project {0} build {1}: {2} in {3}: {4} {5}}
     */
    public static String SummaryOnlyBuildToChatNotifier_SummaryExtra(Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        return holder.format("SummaryOnlyBuildToChatNotifier.SummaryExtra", arg0, arg1, arg2, arg3, arg4, arg5);
    }

    /**
     * Key {@code SummaryOnlyBuildToChatNotifier.SummaryExtra}: {@code
     * Project {0} build {1}: {2} in {3}: {4} {5}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, as {@link String#valueOf(Object)}.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg5
     *      6th format parameter, {@code {5}}, as {@link String#valueOf(Object)}.
     * @param arg4
     *      5th format parameter, {@code {4}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Project {0} build {1}: {2} in {3}: {4} {5}}
     */
    public static Localizable _SummaryOnlyBuildToChatNotifier_SummaryExtra(Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        return new Localizable(holder, "SummaryOnlyBuildToChatNotifier.SummaryExtra", arg0, arg1, arg2, arg3, arg4, arg5);
    }

    /**
     * Key {@code ExtraMessageOnlyBuildToChatNotifier.StartMessage}: {@code
     * Starting build {0} for job {1}: {2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Starting build {0} for job {1}: {2}}
     */
    public static String ExtraMessageOnlyBuildToChatNotifier_StartMessage(Object arg0, Object arg1, Object arg2) {
        return holder.format("ExtraMessageOnlyBuildToChatNotifier.StartMessage", arg0, arg1, arg2);
    }

    /**
     * Key {@code ExtraMessageOnlyBuildToChatNotifier.StartMessage}: {@code
     * Starting build {0} for job {1}: {2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Starting build {0} for job {1}: {2}}
     */
    public static Localizable _ExtraMessageOnlyBuildToChatNotifier_StartMessage(Object arg0, Object arg1, Object arg2) {
        return new Localizable(holder, "ExtraMessageOnlyBuildToChatNotifier.StartMessage", arg0, arg1, arg2);
    }

    /**
     * Key {@code ExtraMessageOnlyBuildToChatNotifier.Message}: {@code
     * Project {0} build {1}: {2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Project {0} build {1}: {2}}
     */
    public static String ExtraMessageOnlyBuildToChatNotifier_Message(Object arg0, Object arg1, Object arg2) {
        return holder.format("ExtraMessageOnlyBuildToChatNotifier.Message", arg0, arg1, arg2);
    }

    /**
     * Key {@code ExtraMessageOnlyBuildToChatNotifier.Message}: {@code
     * Project {0} build {1}: {2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Project {0} build {1}: {2}}
     */
    public static Localizable _ExtraMessageOnlyBuildToChatNotifier_Message(Object arg0, Object arg1, Object arg2) {
        return new Localizable(holder, "ExtraMessageOnlyBuildToChatNotifier.Message", arg0, arg1, arg2);
    }

}
