/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.im.tools;

import hudson.model.AbstractBuild;
import hudson.model.Result;
import hudson.model.ResultTrend;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.User;
import hudson.scm.ChangeLogSet;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class BuildHelper {
    private BuildHelper() {
    }

    @Deprecated
    public static boolean isFix(AbstractBuild<?, ?> build) {
        if (build.getResult() != Result.SUCCESS) {
            return false;
        }
        AbstractBuild<?, ?> previousBuild = BuildHelper.getPreviousNonAbortedBuild(build);
        if (previousBuild != null) {
            Result previousResult = previousBuild.getResult();
            return previousResult != null && previousResult.isWorseThan(Result.SUCCESS);
        }
        return false;
    }

    public static ResultTrend getResultTrend(Run<?, ?> run) {
        if (run.getResult() == null) {
            return ResultTrend.NOT_BUILT;
        }
        return ResultTrend.getResultTrend(run);
    }

    public static boolean isFix(Run<?, ?> run) {
        return BuildHelper.getResultTrend(run) == ResultTrend.FIXED;
    }

    public static boolean isSuccessOrInProgress(Run<?, ?> run) {
        return run.getResult() == null || run.getResult() == Result.SUCCESS;
    }

    @Deprecated
    public static boolean isFailureOrUnstable(AbstractBuild<?, ?> build) {
        return build.getResult() == Result.FAILURE || build.getResult() == Result.UNSTABLE;
    }

    @Deprecated
    public static boolean isStillFailureOrUnstable(AbstractBuild<?, ?> build) {
        ExtResult result = BuildHelper.getExtendedResult(build);
        return result == ExtResult.STILL_FAILING || result == ExtResult.STILL_UNSTABLE;
    }

    public static AbstractBuild<?, ?> getPreviousNonAbortedBuild(AbstractBuild<?, ?> build) {
        AbstractBuild previousBuild;
        for (previousBuild = build.getPreviousBuild(); previousBuild != null; previousBuild = previousBuild.getPreviousBuild()) {
            if (previousBuild.getResult() == Result.ABORTED || previousBuild.getResult() == Result.NOT_BUILT) {
                continue;
            }
            return previousBuild;
        }
        return previousBuild;
    }

    public static AbstractBuild<?, ?> getPreviousSuccessfulBuild(AbstractBuild<?, ?> build) {
        for (AbstractBuild previousBuild = build.getPreviousBuild(); previousBuild != null; previousBuild = previousBuild.getPreviousBuild()) {
            if (previousBuild.getResult() != Result.SUCCESS) {
                continue;
            }
            return previousBuild;
        }
        return null;
    }

    @Deprecated
    public static String getResultDescription(AbstractBuild<?, ?> build) {
        ExtResult result = BuildHelper.getExtendedResult(build);
        return result.toString();
    }

    public static ExtResult getExtendedResult(AbstractBuild<?, ?> build) {
        Result result = build.getResult();
        if (result == Result.ABORTED) {
            return ExtResult.ABORTED;
        }
        if (result == Result.NOT_BUILT) {
            return ExtResult.NOT_BUILT;
        }
        if (result == Result.SUCCESS) {
            if (BuildHelper.isFix(build)) {
                return ExtResult.FIXED;
            }
            return ExtResult.SUCCESS;
        }
        AbstractBuild<?, ?> previousBuild = BuildHelper.getPreviousNonAbortedBuild(build);
        if (result == Result.UNSTABLE) {
            if (previousBuild == null) {
                return ExtResult.UNSTABLE;
            }
            if (previousBuild.getResult() == Result.UNSTABLE) {
                return ExtResult.STILL_UNSTABLE;
            }
            if (previousBuild.getResult() == Result.FAILURE) {
                return ExtResult.NOW_UNSTABLE;
            }
            return ExtResult.UNSTABLE;
        }
        if (result == Result.FAILURE) {
            if (previousBuild != null && previousBuild.getResult() == Result.FAILURE) {
                return ExtResult.STILL_FAILING;
            }
            return ExtResult.FAILURE;
        }
        throw new IllegalArgumentException("Unknown result: '" + result + "' for build: " + build);
    }

    public static String getProjectName(Run<?, ?> run) {
        return run.getParent().getFullDisplayName();
    }

    public static List<ChangeLogSet<ChangeLogSet.Entry>> getChangelogSets(Run<?, ?> run, TaskListener listener) {
        if (run instanceof AbstractBuild) {
            return BuildHelper.getChangelogSetsFromAbstractBuild((AbstractBuild)run);
        }
        return BuildHelper.getChangelogSetsTheHardWay(run, listener);
    }

    public static Set<User> getCommitters(Run<?, ?> run, TaskListener listener) {
        List<ChangeLogSet<ChangeLogSet.Entry>> changelogSets = BuildHelper.getChangelogSets(run, listener);
        HashSet<User> users = new HashSet<User>();
        for (ChangeLogSet<ChangeLogSet.Entry> set : changelogSets) {
            BuildHelper.addChangeSetUsers(set, users);
        }
        return users;
    }

    public static List<ChangeLogSet<ChangeLogSet.Entry>> getChangelogSetsFromAbstractBuild(AbstractBuild build) {
        LinkedList<ChangeLogSet<ChangeLogSet.Entry>> result = new LinkedList<ChangeLogSet<ChangeLogSet.Entry>>();
        result.add(build.getChangeSet());
        return result;
    }

    public static List<ChangeLogSet<ChangeLogSet.Entry>> getChangelogSetsTheHardWay(Run<?, ?> run, TaskListener listener) {
        List<ChangeLogSet<ChangeLogSet.Entry>> result = Collections.emptyList();
        try {
            Method getChangeSets = run.getClass().getMethod("getChangeSets", new Class[0]);
            if (List.class.isAssignableFrom(getChangeSets.getReturnType())) {
                result = new ArrayList<ChangeLogSet<ChangeLogSet.Entry>>((List)getChangeSets.invoke(run, new Object[0]));
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            listener.error("Exception getting changesets for %s: %s", new Object[]{run, e});
        }
        return result;
    }

    private static void addChangeSetUsers(ChangeLogSet<?> changeLogSet, Set<User> users) {
        HashSet<User> changeAuthors = new HashSet<User>();
        for (ChangeLogSet.Entry change : changeLogSet) {
            User changeAuthor = change.getAuthor();
            changeAuthors.add(changeAuthor);
        }
        users.addAll(changeAuthors);
    }

    @Deprecated
    public static enum ExtResult {
        FIXED,
        SUCCESS,
        NOW_UNSTABLE("NOW UNSTABLE"),
        STILL_UNSTABLE("STILL UNSTABLE"),
        UNSTABLE,
        STILL_FAILING("STILL FAILING"),
        FAILURE,
        ABORTED,
        NOT_BUILT("NOT BUILT");

        private final String description;

        private ExtResult() {
            this.description = null;
        }

        private ExtResult(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description != null ? this.description : super.toString();
        }
    }
}

