/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.im.bot;

import hudson.Extension;
import hudson.Util;
import hudson.model.Build;
import hudson.model.Computer;
import hudson.model.Executor;
import hudson.model.Item;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.queue.SubTask;
import hudson.plugins.im.IMChat;
import hudson.plugins.im.IMException;
import hudson.plugins.im.IMMessage;
import hudson.plugins.im.Sender;
import hudson.plugins.im.bot.Bot;
import hudson.plugins.im.bot.BotCommand;
import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import jenkins.model.JenkinsLocationConfiguration;
import org.jenkinsci.plugins.workflow.support.steps.ExecutorStepExecution;

@Extension
public class CurrentlyBuildingCommand
extends BotCommand {
    private static final String SYNTAX = " [@|#] [?] [~ regex pattern]";
    private static final String HELP = " [@|#] [?] [~ regex pattern] - list jobs which are currently in progress, with optional '@' display of URLs to the build (console log if possible) and/or '~ regex' filter on reported lines; '#' returns just the match count; '?' enables debugging of the command itself";

    @Override
    public Collection<String> getCommandNames() {
        return Arrays.asList("currentlyBuilding", "cb");
    }

    @Override
    public void executeCommand(Bot bot, IMChat chat, IMMessage message, Sender sender, String[] args) throws IMException {
        StringBuffer msg = new StringBuffer();
        String filterRegex = null;
        Pattern filterPattern = null;
        boolean reportUrls = false;
        boolean reportCountOnly = false;
        boolean cbDebug = false;
        block12: for (int a = 1; args.length > a; ++a) {
            if (cbDebug) {
                chat.sendMessage("a=" + a + "  arg='" + args[a] + "' len=" + args.length + "\n");
            }
            switch (args[a]) {
                case "#": {
                    msg.append("\n- NOTE: got # argument for currentlyBuilding: will only report the matched-item counts");
                    reportCountOnly = true;
                    continue block12;
                }
                case "@": {
                    msg.append("\n- NOTE: got @ argument for currentlyBuilding: will add URLs to reported strings");
                    reportUrls = true;
                    continue block12;
                }
                case "?": {
                    msg.append("\n- NOTE: got ? argument for currentlyBuilding: will add debug about detected Executable and SubTask class objects");
                    cbDebug = true;
                    continue block12;
                }
                case "~": {
                    if (args.length - a < 1) {
                        msg.append("\n- WARNING: got ~ filtering argument for currentlyBuilding, but no filter value - so none was applied\n");
                        break block12;
                    }
                    for (int i = a + 1; i < args.length; ++i) {
                        filterRegex = a + 1 == i ? args[i] : filterRegex + " " + args[i];
                    }
                    if (filterRegex == null) {
                        msg.append("\n- WARNING: got ~ filtering argument for currentlyBuilding, but failed to extract a filter value (maybe a bug in instant-messaging-plugin) - so none was applied\n");
                        break block12;
                    }
                    msg.append("\n- NOTE: got ~ filtering argument for currentlyBuilding: applying regex filter to reported strings: " + filterRegex);
                    filterPattern = Pattern.compile(filterRegex);
                    break block12;
                }
                default: {
                    msg.append("\n- WARNING: got unsupported argument '" + args[a] + "' for currentlyBuilding, ignored; no filter was applied\n");
                    if (!cbDebug) continue block12;
                    msg.append(this.giveSyntax(sender.getNickname(), args[0]));
                }
            }
        }
        String rootUrl = null;
        if (reportUrls && !reportCountOnly) {
            JenkinsLocationConfiguration cfg = JenkinsLocationConfiguration.get();
            if (cfg != null) {
                rootUrl = cfg.getUrl();
            }
            if (rootUrl == null) {
                msg.append("\n- WARNING: Could not determine Jenkins URL for reporting.\n");
            } else {
                rootUrl = rootUrl.replaceFirst("/*$", "") + "/";
            }
        }
        int countJobsInProgess = 0;
        int countJobsInPattern = 0;
        for (Computer computer : Jenkins.getInstance().getComputers()) {
            for (Executor executor : computer.getExecutors()) {
                Queue.Executable currentExecutable = executor.getCurrentExecutable();
                if (currentExecutable == null) continue;
                ++countJobsInProgess;
                Build currentExecutableBuild = null;
                if (currentExecutable instanceof Build) {
                    currentExecutableBuild = (Build)currentExecutable;
                }
                SubTask task = currentExecutable.getParent();
                Item item = null;
                if (task instanceof Item) {
                    item = (Item)task;
                }
                ExecutorStepExecution.PlaceholderTask placeholderTask = null;
                if (task instanceof ExecutorStepExecution.PlaceholderTask) {
                    placeholderTask = (ExecutorStepExecution.PlaceholderTask)task;
                }
                StringBuffer msgLine = new StringBuffer();
                msgLine.append(computer.getDisplayName());
                msgLine.append("#");
                msgLine.append(executor.getNumber());
                msgLine.append(": ");
                if (item == null) {
                    if (cbDebug) {
                        msgLine.append("task.getDisplayName()= ");
                    }
                    msgLine.append(task.getDisplayName());
                } else if (currentExecutableBuild != null) {
                    if (cbDebug) {
                        msgLine.append("currentExecutableBuild.getFullDisplayName()= ");
                    }
                    msgLine.append(currentExecutableBuild.getFullDisplayName());
                } else if (task instanceof Run) {
                    if (cbDebug) {
                        msgLine.append(" RunTask_data_of_Item= ");
                    }
                    Run r = (Run)task;
                    msgLine.append(item.getFullDisplayName());
                    msgLine.append("#");
                    msgLine.append(r.getNumber());
                }
                if (reportUrls && !reportCountOnly) {
                    String relativeUrl = null;
                    if (currentExecutableBuild != null) {
                        if (cbDebug) {
                            msgLine.append(" URL:currExec= ");
                        }
                        relativeUrl = currentExecutableBuild.getUrl();
                    }
                    if ((relativeUrl == null || relativeUrl.equals("")) && placeholderTask != null) {
                        if (cbDebug) {
                            msgLine.append(" URL:phTask= ");
                        }
                        relativeUrl = placeholderTask.getUrl();
                    }
                    if ((relativeUrl == null || relativeUrl.equals("")) && item != null) {
                        if (cbDebug) {
                            msgLine.append(" URL:item= ");
                        }
                        relativeUrl = item.getUrl();
                    }
                    if (relativeUrl == null || relativeUrl.equals("")) {
                        if (cbDebug) {
                            msgLine.append(" URL:ownerTask= ");
                        }
                        Queue.Task t = task.getOwnerTask();
                        relativeUrl = t.getUrl();
                    }
                    if (relativeUrl != null && !relativeUrl.equals("")) {
                        Pattern p = Pattern.compile("/[0-9]+/*$");
                        Matcher m = p.matcher(relativeUrl);
                        if (m.find()) {
                            relativeUrl = relativeUrl.replaceFirst("/*$", "") + "/console";
                        }
                        msgLine.append(" @ ");
                        msgLine.append(rootUrl + relativeUrl);
                    }
                }
                if (filterPattern != null) {
                    Matcher matcher = filterPattern.matcher(msgLine);
                    if (!matcher.find()) continue;
                    ++countJobsInPattern;
                }
                if (reportCountOnly) continue;
                msg.append("\n- ");
                msg.append(msgLine);
                msg.append(" (Elapsed time: ");
                msg.append(Util.getTimeSpanString((long)executor.getElapsedTime()));
                msg.append(", Estimated remaining time: ");
                msg.append(executor.getEstimatedRemainingTime());
                msg.append(")");
                if (!cbDebug) continue;
                msg.append("\n=== currExec class: ");
                msg.append(Arrays.asList(currentExecutable.getClass().getName()));
                msg.append("\n=== currExec interfaces: ");
                msg.append(Arrays.asList(currentExecutable.getClass().getInterfaces()));
                msg.append("\n=== currExec classes: ");
                msg.append(Arrays.asList(currentExecutable.getClass().getClasses()));
                msg.append("\n=== currTask class: ");
                msg.append(Arrays.asList(task.getClass().getName()));
                msg.append("\n=== currTask interfaces: ");
                msg.append(Arrays.asList(task.getClass().getInterfaces()));
                msg.append("\n=== currTask classes: ");
                msg.append(Arrays.asList(task.getClass().getClasses()));
                msg.append("\n");
            }
        }
        if (countJobsInProgess == 0) {
            if (cbDebug) {
                msg.append("\n- ");
            } else {
                msg = null;
                msg = new StringBuffer();
            }
            msg.append("No jobs are running");
        } else {
            if (countJobsInPattern == 0 && filterPattern != null) {
                msg.append("\n- None of the running jobs matched the filter.");
            }
            if (filterPattern != null) {
                msg.insert(0, "Currently building (" + countJobsInProgess + " items total, of which " + countJobsInPattern + " items matched the filter):");
            } else {
                msg.insert(0, "Currently building (" + countJobsInProgess + " items):");
            }
        }
        chat.sendMessage(msg.toString());
    }

    private String giveSyntax(String sender, String cmd) {
        return sender + ": syntax is: '" + cmd + SYNTAX + "'";
    }

    @Override
    public String getHelp() {
        return HELP;
    }
}

