/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.im.bot;

import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.Item;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Queue;
import hudson.model.SimpleParameterDefinition;
import hudson.model.User;
import hudson.plugins.im.IMCause;
import hudson.plugins.im.Sender;
import hudson.plugins.im.bot.AbstractTextSendingCommand;
import hudson.plugins.im.bot.Bot;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import org.apache.commons.lang.ArrayUtils;

@Extension
public class BuildCommand
extends AbstractTextSendingCommand {
    private static final Pattern NUMERIC_EXTRACTION_REGEX = Pattern.compile("^(\\d+)");
    private static final String SYNTAX = " <job> [now|<delay>[s|m|h]] [<parameterkey>=<value>]*";
    private static final String HELP = " <job> [now|<delay>[s|m|h]] [<parameterkey>=<value>]* - schedule a job build, with standard, custom or no quiet period";

    @Override
    public Collection<String> getCommandNames() {
        return Arrays.asList("build", "schedule");
    }

    private boolean scheduleBuild(Bot bot, AbstractProject<?, ?> project, int delaySeconds, Sender sender, List<ParameterValue> parameters) {
        String senderId = sender.getId();
        if (senderId == null) {
            senderId = sender.getNickname();
        }
        IMCause cause = new IMCause("Started by " + bot.getImId() + " on request of '" + senderId + "'");
        if (parameters.isEmpty()) {
            return project.scheduleBuild(delaySeconds, (Cause)cause);
        }
        return project.scheduleBuild(delaySeconds, (Cause)cause, new Action[]{new ParametersAction(parameters)});
    }

    @Override
    public String getReply(Bot bot, Sender sender, String[] args) {
        if (args.length >= 2) {
            String jobName = args[1];
            jobName = jobName.replaceAll("\"", "");
            AbstractProject<?, ?> project = this.getJobProvider().getJobByNameOrDisplayName(jobName);
            if (project != null) {
                String checkPermission = this.checkPermission(sender, project);
                if (checkPermission != null) {
                    return checkPermission;
                }
                StringBuilder reply = new StringBuilder();
                if (!project.isBuildable()) {
                    return sender.getNickname() + ": job " + jobName + " is disabled";
                }
                int delay = project.getQuietPeriod();
                List<ParameterValue> parameters = new ArrayList<ParameterValue>();
                if (args.length >= 3) {
                    int parametersStartIndex = 2;
                    if (!args[2].contains("=")) {
                        parametersStartIndex = 3;
                        String delayStr = args[2].trim();
                        if ("now".equalsIgnoreCase(delayStr)) {
                            delay = 0;
                        } else {
                            int multiplicator = 1;
                            if (delayStr.endsWith("m") || delayStr.endsWith("min")) {
                                multiplicator = 60;
                            } else if (delayStr.endsWith("h")) {
                                multiplicator = 3600;
                            } else {
                                char c = delayStr.charAt(delayStr.length() - 1);
                                if (c != 's' && !Character.isDigit(c)) {
                                    return this.giveSyntax(sender.getNickname(), args[0]);
                                }
                            }
                            Matcher matcher = NUMERIC_EXTRACTION_REGEX.matcher(delayStr);
                            if (matcher.find()) {
                                int value = Integer.parseInt(matcher.group(1));
                                delay = multiplicator * value;
                            } else {
                                return this.giveSyntax(sender.getNickname(), args[0]);
                            }
                        }
                    }
                    if (parametersStartIndex < args.length) {
                        String[] potentialParameters = (String[])ArrayUtils.subarray((Object[])args, (int)parametersStartIndex, (int)args.length);
                        parameters = this.parseBuildParameters(potentialParameters, project, reply);
                    }
                }
                if (this.scheduleBuild(bot, project, delay, sender, parameters)) {
                    if (delay == 0) {
                        return reply.append(sender.getNickname() + ": job " + jobName + " build scheduled now").toString();
                    }
                    return reply.append(sender.getNickname() + ": job " + jobName + " build scheduled with a quiet period of " + delay + " seconds").toString();
                }
                Queue.Item queueItem = project.getQueueItem();
                if (queueItem != null) {
                    return sender.getNickname() + ": job " + jobName + " is already in the build queue (" + queueItem.getWhy() + ")";
                }
                return sender.getNickname() + ": job " + jobName + " scheduling failed or already in build queue";
            }
            return this.giveSyntax(sender.getNickname(), args[0]) + " (or, did you type the project name correctly?)";
        }
        return sender.getNickname() + ": Error, syntax is: '" + args[0] + SYNTAX + "'";
    }

    List<ParameterValue> parseBuildParameters(String[] args, AbstractProject<?, ?> project, StringBuilder commandReply) {
        if (args.length > 0 && !project.isParameterized()) {
            commandReply.append("Ignoring parameters as project is not parametrized!\n");
            return Collections.emptyList();
        }
        if (!project.isParameterized()) {
            return Collections.emptyList();
        }
        HashMap<String, String> parsedParameters = new HashMap<String, String>();
        for (int i = 0; i < args.length; ++i) {
            String[] split = args[i].split("=");
            if (split.length == 2) {
                parsedParameters.put(split[0], split[1]);
                continue;
            }
            commandReply.append("Unparseable parameter: " + args[i] + "\n");
        }
        ArrayList<ParameterValue> parameters = new ArrayList<ParameterValue>();
        ParametersDefinitionProperty propDefs = (ParametersDefinitionProperty)project.getProperty(ParametersDefinitionProperty.class);
        for (ParameterDefinition pd : propDefs.getParameterDefinitions()) {
            if (pd.getName() != null && parsedParameters.containsKey(pd.getName())) {
                if (pd instanceof SimpleParameterDefinition) {
                    SimpleParameterDefinition spd = (SimpleParameterDefinition)pd;
                    parameters.add(spd.createValue((String)parsedParameters.get(pd.getName())));
                    continue;
                }
                commandReply.append("Unsupported parameter type " + pd.getClass().getSimpleName() + " for parameter " + pd.getName() + "!\n");
                continue;
            }
            ParameterValue pv = pd.getDefaultParameterValue();
            if (pv == null) continue;
            parameters.add(pv);
        }
        return parameters;
    }

    private String checkPermission(Sender sender, AbstractProject<?, ?> project) {
        if (project == null) {
            return "ERROR in checkPermission() : project not specified";
        }
        if (project.hasPermission(Item.BUILD)) {
            return null;
        }
        User senderUser = null;
        try {
            senderUser = User.getById((String)sender.getNickname(), (boolean)false);
        }
        catch (Exception e) {
            senderUser = null;
        }
        if (senderUser == null) {
            try {
                senderUser = User.getById((String)sender.getId(), (boolean)false);
            }
            catch (Exception e) {
                senderUser = null;
            }
        }
        if (senderUser != null) {
            if (Jenkins.getInstance().getAuthorizationStrategy().getACL(project).hasPermission(senderUser.impersonate(), Item.BUILD)) {
                System.err.println("IM BuildCommand authorized Jenkins user '" + senderUser.getId() + "' (IM ID '" + sender.getNickname() + "' / '" + sender.getId() + "') to build '" + project.getName() + "' (specific project matched, or user may generally build Items and the project does not constrain further)");
                return null;
            }
            return sender.getNickname() + " (" + sender.getId() + " aka " + senderUser.getId() + "): you're not allowed to build job " + project.getDisplayName() + "!";
        }
        return sender.getNickname() + " (" + sender.getId() + "): you're not allowed to build job " + project.getDisplayName() + "!";
    }

    private String giveSyntax(String sender, String cmd) {
        return sender + ": syntax is: '" + cmd + SYNTAX + "'";
    }

    @Override
    public String getHelp() {
        return HELP;
    }
}

