/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.im.bot;

import hudson.Extension;
import hudson.plugins.im.AuthenticationHolder;
import hudson.plugins.im.IMChat;
import hudson.plugins.im.IMException;
import hudson.plugins.im.IMMessage;
import hudson.plugins.im.IMMessageListener;
import hudson.plugins.im.Sender;
import hudson.plugins.im.bot.BotCommand;
import hudson.plugins.im.bot.SetAliasCommand;
import hudson.plugins.im.tools.ExceptionHelper;
import hudson.plugins.im.tools.MessageHelper;
import hudson.remoting.Callable;
import hudson.security.ACL;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.security.NotReallyRoleSensitiveCallable;
import org.acegisecurity.Authentication;

public class Bot
implements IMMessageListener {
    private static final Logger LOGGER = Logger.getLogger(Bot.class.getName());
    private final SortedMap<String, BotCommand> cmdsAndAliases = new TreeMap<String, BotCommand>();
    private final IMChat chat;
    private final String nick;
    private final String imServer;
    private final String commandPrefix;
    private boolean commandsAccepted;
    private String helpCache = null;
    private final AuthenticationHolder authentication;

    public Bot(IMChat chat, String nick, String imServer, String commandPrefix, AuthenticationHolder authentication) {
        this.chat = chat;
        this.nick = nick;
        this.imServer = imServer;
        this.commandPrefix = commandPrefix;
        this.authentication = authentication;
        this.commandsAccepted = chat.isCommandsAccepted();
        for (BotCommand cmd : BotCommand.all()) {
            for (String name : cmd.getCommandNames()) {
                this.cmdsAndAliases.put(name, cmd);
            }
        }
        chat.addMessageListener(this);
    }

    public String getImId() {
        return this.nick + "@" + this.imServer;
    }

    @Override
    public void onMessage(final IMMessage msg) {
        String payload = this.retrieveMessagePayLoad(msg.getBody());
        if (payload != null) {
            final Sender s = this.getSender(msg);
            try {
                if (!this.commandsAccepted) {
                    this.chat.sendMessage(s.getNickname() + " you may not issue bot commands in this chat!");
                    return;
                }
                if (!msg.isAuthorized()) {
                    this.chat.sendMessage(s.getNickname() + " you're not a buddy of me. I won't take any commands from you!");
                    return;
                }
            }
            catch (IMException e) {
                LOGGER.warning(ExceptionHelper.dump(e));
                return;
            }
            final String[] args = MessageHelper.extractCommandLine(payload);
            if (args.length > 0) {
                String cmd = args[0];
                try {
                    final BotCommand command = (BotCommand)this.cmdsAndAliases.get(cmd);
                    if (command != null) {
                        if (this.isAuthenticationNeeded()) {
                            ACL.impersonate((Authentication)this.authentication.getAuthentication(), (Callable)new NotReallyRoleSensitiveCallable<Void, IMException>(){
                                private static final long serialVersionUID = 1L;

                                public Void call() throws IMException {
                                    command.executeCommand(Bot.this, Bot.this.chat, msg, s, args);
                                    return null;
                                }
                            });
                        } else {
                            command.executeCommand(this, this.chat, msg, s, args);
                        }
                    } else {
                        this.chat.sendMessage(s.getNickname() + " did you mean me? Unknown command '" + cmd + "'\nUse '" + this.commandPrefix + " help' to get help!");
                    }
                }
                catch (Exception e) {
                    LOGGER.warning(ExceptionHelper.dump(e));
                }
            }
        }
    }

    private boolean isAuthenticationNeeded() {
        return this.authentication != null && Jenkins.getInstance().isUseSecurity();
    }

    private Sender getSender(IMMessage msg) {
        String sender = msg.getFrom();
        String id = this.chat.getIMId(sender);
        Sender s = id != null ? new Sender(this.chat.getNickName(sender), id) : new Sender(this.chat.getNickName(sender));
        return s;
    }

    private static boolean isNickSeparator(String candidate) {
        return ":".equals(candidate) || ",".equals(candidate);
    }

    private String retrieveMessagePayLoad(String body) {
        if (body == null) {
            return null;
        }
        if (body.startsWith(this.commandPrefix)) {
            return body.substring(this.commandPrefix.length()).trim();
        }
        if (body.startsWith(this.nick) && Bot.isNickSeparator(body.substring(this.nick.length(), this.nick.length() + 1))) {
            return body.substring(this.nick.length() + 1).trim();
        }
        return null;
    }

    BotCommand getCommand(String name) {
        return (BotCommand)this.cmdsAndAliases.get(name);
    }

    BotCommand addAlias(String name, BotCommand alias) {
        BotCommand old = (BotCommand)this.cmdsAndAliases.get(name);
        if (old != null && !(old instanceof SetAliasCommand.AliasCommand)) {
            throw new IllegalArgumentException("Won't override built-in command: '" + name + "'!");
        }
        this.cmdsAndAliases.put(name, alias);
        this.helpCache = null;
        return old;
    }

    SetAliasCommand.AliasCommand removeAlias(String name) {
        BotCommand alias = (BotCommand)this.cmdsAndAliases.get(name);
        if (alias instanceof SetAliasCommand.AliasCommand) {
            this.cmdsAndAliases.remove(name);
            return (SetAliasCommand.AliasCommand)alias;
        }
        if (alias != null) {
            throw new IllegalArgumentException("Won't remove built-in command: '" + name + "'!");
        }
        return null;
    }

    SortedMap<String, SetAliasCommand.AliasCommand> getAliases() {
        TreeMap<String, SetAliasCommand.AliasCommand> result = new TreeMap<String, SetAliasCommand.AliasCommand>();
        for (Map.Entry<String, BotCommand> entry : this.cmdsAndAliases.entrySet()) {
            if (!(entry.getValue() instanceof SetAliasCommand.AliasCommand)) continue;
            result.put(entry.getKey(), (SetAliasCommand.AliasCommand)entry.getValue());
        }
        return result;
    }

    public void shutdown() {
        this.chat.removeMessageListener(this);
        if (this.chat.isMultiUserChat()) {
            try {
                this.chat.sendMessage("Oops, seems like Jenkins is going down now. See ya!");
            }
            catch (IMException iMException) {
                // empty catch block
            }
        }
    }

    @Extension
    public static class HelpCommand
    extends BotCommand {
        @Override
        public Collection<String> getCommandNames() {
            return Collections.singleton("help");
        }

        @Override
        public void executeCommand(Bot bot, IMChat groupChat, IMMessage message, Sender sender, String[] args) throws IMException {
            if (bot.helpCache == null) {
                StringBuilder msg = new StringBuilder("Available commands:");
                for (Map.Entry item : bot.cmdsAndAliases.entrySet()) {
                    if (item.getValue() == this || ((BotCommand)item.getValue()).getHelp() == null) continue;
                    msg.append("\n");
                    msg.append((String)item.getKey());
                    msg.append(((BotCommand)item.getValue()).getHelp());
                }
                bot.helpCache = msg.toString();
            }
            groupChat.sendMessage(bot.helpCache);
        }

        @Override
        public String getHelp() {
            return null;
        }
    }
}

