/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.im;

import hudson.model.ResultTrend;
import hudson.model.Run;
import hudson.plugins.im.tools.BuildHelper;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum NotificationStrategy {
    ALL("all"){

        @Override
        public boolean notificationWanted(Run<?, ?> run) {
            return true;
        }
    }
    ,
    ANY_FAILURE("failure"){

        @Override
        public boolean notificationWanted(Run<?, ?> run) {
            return !BuildHelper.isSuccessOrInProgress(run);
        }
    }
    ,
    FAILURE_AND_FIXED("failure and fixed"){

        @Override
        public boolean notificationWanted(Run<?, ?> run) {
            if (!BuildHelper.isSuccessOrInProgress(run)) {
                return true;
            }
            return BuildHelper.isFix(run);
        }
    }
    ,
    NEW_FAILURE_AND_FIXED("new failure and fixed"){

        @Override
        public boolean notificationWanted(Run<?, ?> run) {
            ResultTrend trend = BuildHelper.getResultTrend(run);
            return trend == ResultTrend.FAILURE || trend == ResultTrend.FIXED;
        }
    }
    ,
    STATECHANGE_ONLY("change"){

        @Override
        public boolean notificationWanted(Run<?, ?> run) {
            Run previousBuild = run.getPreviousBuild();
            return previousBuild == null || run.getResult() != previousBuild.getResult();
        }
    };

    private static final String[] DISPLAY_NAMES;
    private final String displayName;

    private NotificationStrategy(String displayName) {
        this.displayName = displayName;
    }

    public abstract boolean notificationWanted(Run<?, ?> var1);

    public String getDisplayName() {
        return this.displayName;
    }

    public static NotificationStrategy forDisplayName(String displayName) {
        for (NotificationStrategy strategy : NotificationStrategy.values()) {
            if (!strategy.getDisplayName().equals(displayName)) continue;
            return strategy;
        }
        return null;
    }

    public static List<String> getDisplayNamesList() {
        List<Object> resultList = Arrays.asList((Object[])DISPLAY_NAMES.clone());
        return Collections.unmodifiableList(resultList);
    }

    @Deprecated
    public static String[] getDisplayNames() {
        return (String[])DISPLAY_NAMES.clone();
    }

    static {
        DISPLAY_NAMES = new String[NotificationStrategy.values().length];
        int i = 0;
        for (NotificationStrategy strategy : NotificationStrategy.values()) {
            NotificationStrategy.DISPLAY_NAMES[i++] = strategy.getDisplayName();
        }
    }
}

