/*
 * Decompiled with CFR 0.152.
 */
package configurationslicing.maven;

import configurationslicing.UnorderedStringSlicer;
import configurationslicing.executeshell.AbstractBuildCommandSlicer;
import hudson.Extension;
import hudson.maven.MavenModuleSet;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.tasks.Builder;
import hudson.tasks.Maven;
import hudson.util.DescribableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class MavenVersionSlicer
extends UnorderedStringSlicer<AbstractProject> {
    public MavenVersionSlicer() {
        super(new MavenVersionSlicerSpec());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MavenVersionSlicerSpec
    extends UnorderedStringSlicer.UnorderedStringSlicerSpec<AbstractProject> {
        private static final String DEFAULT = "(Default)";
        private static final String MULTIPLE = "(MULTIPLE)";

        @Override
        public String getDefaultValueString() {
            return DEFAULT;
        }

        @Override
        public String getName() {
            return "Maven Version";
        }

        @Override
        public String getName(AbstractProject item) {
            return item.getFullName();
        }

        @Override
        public String getUrl() {
            return "mavenversion";
        }

        @Override
        public List<String> getValues(AbstractProject item) {
            if (item instanceof MavenModuleSet) {
                return this.getValues((MavenModuleSet)item);
            }
            ArrayList<String> ret = new ArrayList<String>();
            List<Maven> builders = this.getBuilders(item);
            if (builders.isEmpty()) {
                return ret;
            }
            String last = null;
            HashSet<String> all = new HashSet<String>();
            for (Maven builder : builders) {
                last = builder.mavenName;
                all.add(last);
            }
            if (all.size() > 1) {
                ret.add(MULTIPLE);
            } else if (last != null) {
                ret.add(last);
            } else {
                ret.add(DEFAULT);
            }
            return ret;
        }

        private List<Maven> getBuilders(AbstractProject item) {
            DescribableList<Builder, Descriptor<Builder>> buildersList = AbstractBuildCommandSlicer.AbstractBuildCommandSliceSpec.getBuildersList(item);
            List builders = buildersList.getAll(Maven.class);
            return builders;
        }

        @Override
        public List<String> getValues(MavenModuleSet item) {
            ArrayList<String> ret = new ArrayList<String>();
            Maven.MavenInstallation itemMaven = item.getMaven();
            if (itemMaven != null) {
                String itemMavenName = itemMaven.getName();
                for (Maven.MavenInstallation maven : MavenModuleSet.DESCRIPTOR.getMavenDescriptor().getInstallations()) {
                    String mavenName = maven.getName();
                    if (!itemMavenName.equals(mavenName)) continue;
                    ret.add(itemMavenName);
                }
            }
            return ret;
        }

        @Override
        public List<AbstractProject> getWorkDomain() {
            ArrayList<AbstractProject> list = new ArrayList<AbstractProject>();
            list.addAll(Hudson.getInstance().getAllItems(AbstractProject.class));
            list.addAll(Hudson.getInstance().getAllItems(MavenModuleSet.class));
            return list;
        }

        @Override
        public boolean setValues(AbstractProject item, List<String> set) {
            String mavenVersion = null;
            if (!set.isEmpty()) {
                mavenVersion = set.iterator().next();
            }
            if (MULTIPLE.equals(mavenVersion)) {
                return true;
            }
            if (item instanceof MavenModuleSet) {
                return this.setValues((MavenModuleSet)item, mavenVersion);
            }
            List<Maven> builders = this.getBuilders(item);
            DescribableList<Builder, Descriptor<Builder>> buildersList = AbstractBuildCommandSlicer.AbstractBuildCommandSliceSpec.getBuildersList(item);
            for (Maven builder : builders) {
                String oldName = builder.mavenName;
                if (oldName == null) {
                    oldName = DEFAULT;
                }
                if (oldName.equals(mavenVersion)) continue;
                Maven newMaven = new Maven(builder.targets, mavenVersion, builder.pom, builder.properties, builder.jvmOptions, builder.usePrivateRepository);
                AbstractBuildCommandSlicer.AbstractBuildCommandSliceSpec.replaceBuilder(buildersList, (Builder)builder, (Builder)newMaven);
            }
            return true;
        }

        public boolean setValues(MavenModuleSet item, String mavenVersion) {
            Maven.MavenInstallation old = item.getMaven();
            String oldName = null;
            if (old != null) {
                oldName = old.getName();
            }
            if (mavenVersion.trim().length() == 0 || DEFAULT.equals(mavenVersion)) {
                mavenVersion = null;
            }
            boolean save = false;
            if (mavenVersion == null) {
                if (oldName != null) {
                    save = true;
                }
            } else if (!mavenVersion.equals(oldName)) {
                save = true;
            }
            if (save) {
                item.setMaven(mavenVersion);
                try {
                    item.save();
                    return true;
                }
                catch (IOException e) {
                    return false;
                }
            }
            return false;
        }
    }
}

