/*
 * Decompiled with CFR 0.152.
 */
package configurationslicing.logrotator;

import configurationslicing.UnorderedStringSlicer;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Hudson;
import hudson.tasks.LogRotator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LogRotationSlicer
extends UnorderedStringSlicer<AbstractProject<?, ?>> {
    public LogRotationSlicer(UnorderedStringSlicer.UnorderedStringSlicerSpec<AbstractProject<?, ?>> spec) {
        super(spec);
    }

    public static boolean equals(LogRotator r1, LogRotator r2) {
        if (r1 == r2) {
            return true;
        }
        if (r1 == null || r2 == null) {
            return false;
        }
        if (r1.getDaysToKeep() != r2.getDaysToKeep()) {
            return false;
        }
        if (r1.getNumToKeep() != r2.getNumToKeep()) {
            return false;
        }
        if (r1.getArtifactDaysToKeep() != r2.getArtifactDaysToKeep()) {
            return false;
        }
        return r1.getArtifactNumToKeep() == r2.getArtifactNumToKeep();
    }

    public static class ArtifactBuildsSliceSpec
    extends AbstractLogRotationSliceSpec {
        public ArtifactBuildsSliceSpec() {
            super("Max # of builds to keep with artifacts", "artifactsbuilds");
        }

        protected String getValue(LogRotator rotator) {
            return rotator.getArtifactNumToKeepStr();
        }

        protected int getNewArtifactBuilds(int oldValue, int newValue) {
            return newValue;
        }
    }

    public static class ArtifactDaysSliceSpec
    extends AbstractLogRotationSliceSpec {
        public ArtifactDaysSliceSpec() {
            super("Days to keep artifacts", "artifactsdays");
        }

        protected String getValue(LogRotator rotator) {
            return rotator.getArtifactDaysToKeepStr();
        }

        protected int getNewArtifactDays(int oldDays, int newValue) {
            return newValue;
        }
    }

    public static class LogRotationBuildsSliceSpec
    extends AbstractLogRotationSliceSpec {
        public LogRotationBuildsSliceSpec() {
            super("Max # of builds to keep", "logrotationbuilds");
        }

        protected String getValue(LogRotator rotator) {
            return rotator.getNumToKeepStr();
        }

        protected int getNewBuilds(int oldBuilds, int newValue) {
            return newValue;
        }
    }

    public static class LogRotationDaysSliceSpec
    extends AbstractLogRotationSliceSpec {
        public LogRotationDaysSliceSpec() {
            super("Days to keep builds", "logrotationdays");
        }

        protected String getValue(LogRotator rotator) {
            return rotator.getDaysToKeepStr();
        }

        protected int getNewDays(int oldDays, int newValue) {
            return newValue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class AbstractLogRotationSliceSpec
    extends UnorderedStringSlicer.UnorderedStringSlicerSpec<AbstractProject<?, ?>> {
        private static final String DISABLED = "(Disabled)";
        private String displayName;
        private String url;

        public AbstractLogRotationSliceSpec(String displayName, String url) {
            this.displayName = "Discard Old Builds Slicer - " + displayName;
            this.url = url;
        }

        @Override
        public String getName() {
            return this.displayName;
        }

        @Override
        public String getUrl() {
            return this.url;
        }

        @Override
        public String getDefaultValueString() {
            return DISABLED;
        }

        @Override
        public String getName(AbstractProject<?, ?> item) {
            return item.getFullName();
        }

        @Override
        public List<String> getValues(AbstractProject<?, ?> item) {
            String retString = null;
            LogRotator logrotator = item.getLogRotator();
            if (logrotator == null) {
                retString = DISABLED;
            } else {
                retString = this.getValue(logrotator);
                if (retString.length() == 0) {
                    retString = DISABLED;
                }
            }
            ArrayList<String> ret = new ArrayList<String>();
            ret.add(retString);
            return ret;
        }

        protected abstract String getValue(LogRotator var1);

        @Override
        public List<AbstractProject<?, ?>> getWorkDomain() {
            return Hudson.getInstance().getAllItems(AbstractProject.class);
        }

        @Override
        public boolean setValues(AbstractProject<?, ?> item, List<String> set) {
            LogRotator newlogrotator;
            if (set.isEmpty()) {
                return false;
            }
            LogRotator logrotator = item.getLogRotator();
            int days = -1;
            int builds = -1;
            int artifactDaysToKeep = -1;
            int artifactNumToKeep = -1;
            if (logrotator != null) {
                days = logrotator.getDaysToKeep();
                builds = logrotator.getNumToKeep();
                artifactDaysToKeep = logrotator.getArtifactDaysToKeep();
                artifactNumToKeep = logrotator.getArtifactNumToKeep();
            }
            int newInt = -1;
            String newString = null;
            Iterator<String> i$ = set.iterator();
            if (i$.hasNext()) {
                String line;
                newString = line = i$.next();
            }
            if (!DISABLED.equals(newString)) {
                newInt = Integer.parseInt(newString);
            }
            if (!LogRotationSlicer.equals(newlogrotator = new LogRotator(days = this.getNewDays(days, newInt), builds = this.getNewBuilds(builds, newInt), artifactDaysToKeep = this.getNewArtifactDays(artifactDaysToKeep, newInt), artifactNumToKeep = this.getNewArtifactBuilds(artifactNumToKeep, newInt)), logrotator)) {
                item.setLogRotator(newlogrotator);
                try {
                    item.save();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
                return true;
            }
            return false;
        }

        protected int getNewDays(int oldDays, int newValue) {
            return oldDays;
        }

        protected int getNewBuilds(int oldBuilds, int newValue) {
            return oldBuilds;
        }

        protected int getNewArtifactDays(int oldValue, int newValue) {
            return oldValue;
        }

        protected int getNewArtifactBuilds(int oldValue, int newValue) {
            return oldValue;
        }
    }

    @Extension
    public static class ArtifactBuilds
    extends LogRotationSlicer {
        public ArtifactBuilds() {
            super(new ArtifactBuildsSliceSpec());
        }
    }

    @Extension
    public static class ArtifactDays
    extends LogRotationSlicer {
        public ArtifactDays() {
            super(new ArtifactDaysSliceSpec());
        }
    }

    @Extension
    public static class Count
    extends LogRotationSlicer {
        public Count() {
            super(new LogRotationBuildsSliceSpec());
        }
    }

    @Extension
    public static class Days
    extends LogRotationSlicer {
        public Days() {
            super(new LogRotationDaysSliceSpec());
        }
    }
}

