/*
 * Decompiled with CFR 0.152.
 */
package configurationslicing.customworkspace;

import configurationslicing.UnorderedStringSlicer;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.FreeStyleProject;
import hudson.model.Hudson;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class CustomWorkspaceStringSlicer
extends UnorderedStringSlicer<AbstractProject<?, ?>> {
    public CustomWorkspaceStringSlicer() {
        super(new CustomWorkspaceStringSliceSpec());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CustomWorkspaceStringSliceSpec
    extends UnorderedStringSlicer.UnorderedStringSlicerSpec<AbstractProject<?, ?>> {
        private static final String DISABLED = "(Disabled)";

        @Override
        public String getDefaultValueString() {
            return DISABLED;
        }

        @Override
        public String getName() {
            return "Custom Workspace Slicer";
        }

        @Override
        public String getName(AbstractProject<?, ?> item) {
            return item.getFullName();
        }

        @Override
        public String getUrl() {
            return "customworkspace";
        }

        @Override
        public List<String> getValues(AbstractProject<?, ?> item) {
            FreeStyleProject project;
            String ws;
            ArrayList<String> workspace = new ArrayList<String>();
            if (item instanceof FreeStyleProject && (ws = (project = (FreeStyleProject)item).getCustomWorkspace()) != null) {
                workspace.add(ws);
            }
            if (workspace.isEmpty()) {
                workspace.add(DISABLED);
            }
            return workspace;
        }

        @Override
        public List<AbstractProject<?, ?>> getWorkDomain() {
            return Hudson.getInstance().getAllItems(FreeStyleProject.class);
        }

        @Override
        public boolean setValues(AbstractProject<?, ?> item, List<String> set) {
            try {
                if (item instanceof FreeStyleProject) {
                    String old;
                    FreeStyleProject project = (FreeStyleProject)item;
                    String ws = set.isEmpty() ? null : set.iterator().next();
                    if (DISABLED.equals(ws)) {
                        ws = null;
                    }
                    if (!StringUtils.equals((String)ws, (String)(old = project.getCustomWorkspace()))) {
                        project.setCustomWorkspace(ws);
                    }
                }
                return true;
            }
            catch (IOException ioe) {
                return false;
            }
        }
    }
}

