/*
 * Decompiled with CFR 0.152.
 */
package configurationslicing;

import configurationslicing.ParametersStringSliceSpec;
import configurationslicing.Slice;
import configurationslicing.UnorderedStringSlice;
import hudson.model.Descriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParametersStringSlice<I>
extends UnorderedStringSlice<I> {
    static Logger LOG = Logger.getLogger("ParametersStringSlicing");

    public ParametersStringSlice(ParametersStringSliceSpec<I> spec) {
        super(spec);
    }

    public ParametersStringSliceSpec<I> getParametersSliceSpec() {
        return (ParametersStringSliceSpec)this.getSpec();
    }

    public UnorderedStringSlice<I> getInitialAccumulator() {
        return new ParametersStringSlice<I>(this.getParametersSliceSpec());
    }

    @Override
    public Slice newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
        LOG.warning("formData." + formData);
        List<String> paramValues = this.getStringList(formData, "paramValue");
        ArrayList<String> joinedValues = new ArrayList<String>();
        int paramNamesCount = this.getParametersSliceSpec().getParamNamesCount();
        for (int i = 0; i < paramValues.size(); i += paramNamesCount) {
            StringBuilder buf = new StringBuilder();
            for (int j = 0; j < paramNamesCount; ++j) {
                if (j > 0) {
                    buf.append("@@//@@");
                }
                String value = paramValues.get(i + j);
                buf.append(value);
            }
            joinedValues.add(buf.toString());
        }
        return new UnorderedStringSlice(this.getSpec(), joinedValues, this.getStringList(formData, "itemNames"));
    }
}

