/*
 * Decompiled with CFR 0.152.
 */
package configurationslicing.wscleanup;

import configurationslicing.UnorderedStringSlicer;
import configurationslicing.wscleanup.AbstractWsCleanupSliceSpec;
import hudson.model.AbstractProject;
import hudson.plugins.ws_cleanup.Pattern;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWsCleanupSliceSpec
extends UnorderedStringSlicer.UnorderedStringSlicerSpec<AbstractProject<?, ?>> {
    private static final String DISABLED = "(Disabled)";
    private static final String SEPARATOR = ",";
    private static final String INCLUDE = "+";
    private static final String EXCLUDE = "-";
    private String url;
    private String name;

    public AbstractWsCleanupSliceSpec(String url, String name) {
        this.url = url;
        this.name = name;
    }

    public String getDefaultValueString() {
        return DISABLED;
    }

    public String getName() {
        return this.name;
    }

    public String getName(AbstractProject<?, ?> item) {
        return item.getName();
    }

    public String getUrl() {
        return this.url;
    }

    public List<String> getValues(AbstractProject<?, ?> item) {
        ArrayList<String> values = new ArrayList<String>();
        CleanupInfo info = this.getCleanupInfo(item);
        if (info == null) {
            values.add(DISABLED);
        } else {
            StringBuilder buf = new StringBuilder();
            buf.append(String.valueOf(info.appliesToDirectories));
            if (this.isSkipEnabled()) {
                buf.append(SEPARATOR);
                buf.append(String.valueOf(info.skipWhenFailed));
            }
            for (Pattern pattern : info.patterns) {
                buf.append(SEPARATOR);
                if (pattern.getType() == Pattern.PatternType.EXCLUDE) {
                    buf.append(EXCLUDE);
                } else {
                    buf.append(INCLUDE);
                }
                buf.append(pattern.getPattern());
            }
            values.add(buf.toString());
        }
        return values;
    }

    public abstract CleanupInfo getCleanupInfo(AbstractProject<?, ?> var1);

    public boolean setValues(AbstractProject<?, ?> item, List<String> list) {
        if (list != null && !list.isEmpty()) {
            String value = list.get(0);
            if (value.equals(DISABLED)) {
                this.setCleanupInfo(item, null);
                return true;
            }
            CleanupInfo info = new CleanupInfo();
            String[] split = value.split(SEPARATOR);
            int pos = 0;
            info.appliesToDirectories = Boolean.parseBoolean(split[pos++]);
            if (this.isSkipEnabled()) {
                info.skipWhenFailed = Boolean.parseBoolean(split[pos++]);
            }
            for (int i = pos; i < split.length; ++i) {
                String patternTypeString = split[i].substring(0, 1);
                String patternString = split[i].substring(1);
                Pattern.PatternType type = INCLUDE.equals(patternTypeString) ? Pattern.PatternType.INCLUDE : Pattern.PatternType.EXCLUDE;
                Pattern pattern = new Pattern(patternString, type);
                info.patterns.add(pattern);
            }
            return this.setCleanupInfo(item, info);
        }
        return false;
    }

    public abstract boolean isSkipEnabled();

    public abstract boolean setCleanupInfo(AbstractProject<?, ?> var1, CleanupInfo var2);

    public String getConfiguredValueDescription() {
        StringBuilder buf = new StringBuilder();
        buf.append("Apply to Directories,");
        if (this.isSkipEnabled()) {
            buf.append("Skip on Fail,");
        }
        buf.append("-Exclude Pattern,+Include Pattern,...");
        buf.append("<br/><i>(e.g. false,");
        if (this.isSkipEnabled()) {
            buf.append("true,");
        }
        buf.append("+config/**,-*.xml,-*.txt)</i>");
        return buf.toString();
    }
}

