/*
 * Decompiled with CFR 0.152.
 */
package configurationslicing.prioritysorter;

import configurationslicing.UnorderedStringSlicer;
import hudson.Extension;
import hudson.model.Hudson;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.queueSorter.PrioritySorterJobProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class PrioritySorterSlicer
extends UnorderedStringSlicer<Job<?, ?>> {
    public PrioritySorterSlicer() {
        super(new PrioritySorterSliceSpec());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PrioritySorterSliceSpec
    extends UnorderedStringSlicer.UnorderedStringSlicerSpec<Job<?, ?>> {
        private static final int DEFAULT_PRIORITY_INT = 100;
        private static final String DEFAULT_PRIORITY = String.valueOf(100);

        @Override
        public String getDefaultValueString() {
            return DEFAULT_PRIORITY;
        }

        @Override
        public String getName() {
            return "Job Priority Slicer";
        }

        @Override
        public String getName(Job<?, ?> item) {
            return item.getName();
        }

        @Override
        public String getUrl() {
            return "jobpriority";
        }

        @Override
        public List<String> getValues(Job<?, ?> job) {
            ArrayList<String> values = new ArrayList<String>();
            PrioritySorterJobProperty prop = (PrioritySorterJobProperty)job.getProperty(PrioritySorterJobProperty.class);
            if (prop != null) {
                values.add(String.valueOf(prop.priority));
            } else {
                values.add(DEFAULT_PRIORITY);
            }
            return values;
        }

        @Override
        public List<Job<?, ?>> getWorkDomain() {
            return Hudson.getInstance().getItems(Job.class);
        }

        @Override
        public boolean setValues(Job<?, ?> job, List<String> set) {
            boolean changed;
            int priority;
            String value = set.iterator().next();
            try {
                priority = Integer.parseInt(value);
            }
            catch (NumberFormatException nfe) {
                priority = 100;
            }
            PrioritySorterJobProperty prop = (PrioritySorterJobProperty)job.getProperty(PrioritySorterJobProperty.class);
            if (prop == null) {
                boolean bl = changed = priority != 100;
                if (changed) {
                    try {
                        prop = new PrioritySorterJobProperty(priority);
                        job.addProperty((JobProperty)prop);
                    }
                    catch (IOException e) {
                        return false;
                    }
                }
            } else {
                int oldPriority = prop.priority;
                boolean bl = changed = oldPriority != priority;
                if (changed) {
                    try {
                        job.removeProperty((JobProperty)prop);
                        prop = new PrioritySorterJobProperty(priority);
                        job.addProperty((JobProperty)prop);
                    }
                    catch (IOException e) {
                        return false;
                    }
                }
            }
            return changed;
        }
    }
}

