/*
 * Decompiled with CFR 0.152.
 */
package configurationslicing.executeshell;

import configurationslicing.executeshell.AbstractBuildCommandSlicer;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.tasks.Builder;
import hudson.tasks.Maven;
import hudson.util.DescribableList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class MavenTargetsSlicer
extends AbstractBuildCommandSlicer<Maven> {
    public MavenTargetsSlicer() {
        super(new MavenTargetsSliceSpec());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MavenTargetsSliceSpec
    extends AbstractBuildCommandSlicer.AbstractBuildCommandSliceSpec<Maven> {
        private static final String DEFAULT_MAVEN = "(Default)";

        @Override
        public String getName() {
            return "Maven top-level targets";
        }

        @Override
        public String getUrl() {
            return "maventopleveltargets";
        }

        @Override
        public Maven createBuilder(String command, List<Maven> existingBuilders, Maven oldBuilder) {
            if (oldBuilder != null) {
                String mavenName = oldBuilder.getMaven().getName();
                return new Maven(command, mavenName, oldBuilder.pom, oldBuilder.properties, oldBuilder.jvmOptions, oldBuilder.usePrivateRepository);
            }
            String mavenName = DEFAULT_MAVEN;
            for (Maven maven : existingBuilders) {
                Maven.MavenInstallation install = maven.getMaven();
                if (install == null) continue;
                mavenName = install.getName();
                break;
            }
            return new Maven(command, mavenName);
        }

        public Maven[] createBuilderArray(int len) {
            return new Maven[len];
        }

        @Override
        public String getCommand(Maven builder) {
            return builder.getTargets();
        }

        @Override
        public List<Maven> getConcreteBuildersList(DescribableList<Builder, Descriptor<Builder>> buildersList) {
            return buildersList.getAll(Maven.class);
        }
    }
}

