/*
 * Decompiled with CFR 0.152.
 */
package configurationslicing.email;

import configurationslicing.UnorderedStringSlicer;
import configurationslicing.email.AbstractEmailSliceSpec;
import configurationslicing.email.ProjectHandler;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.plugins.emailext.EmailType;
import hudson.plugins.emailext.ExtendedEmailPublisher;
import hudson.plugins.emailext.plugins.trigger.FailureTrigger;
import hudson.tasks.Publisher;
import hudson.util.DescribableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class ExtEmailSlicer
extends UnorderedStringSlicer<AbstractProject<?, ?>> {
    public ExtEmailSlicer() {
        super(new ExtEmailSliceSpec());
    }

    @Override
    public boolean isLoaded() {
        try {
            new EmailType();
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExtEmailSliceSpec
    extends AbstractEmailSliceSpec
    implements ProjectHandler {
        public ExtEmailSliceSpec() {
            super(",", "Editable Email Notification", "emailext");
        }

        @Override
        protected ProjectHandler getProjectHandler(AbstractProject project) {
            return this;
        }

        @Override
        public List<String> getCommonValueStrings() {
            ArrayList<String> values = new ArrayList<String>();
            values.add("$DEFAULT_RECIPIENTS");
            return values;
        }

        @Override
        public String getRecipients(AbstractProject project) {
            ExtendedEmailPublisher mailer = this.getMailer(project);
            if (mailer != null) {
                return mailer.recipientList;
            }
            return null;
        }

        private ExtendedEmailPublisher getMailer(AbstractProject project) {
            DescribableList publishers = project.getPublishersList();
            Descriptor descriptor = Hudson.getInstance().getDescriptor(ExtendedEmailPublisher.class);
            Publisher emailPublisher = (Publisher)publishers.get(descriptor);
            return (ExtendedEmailPublisher)emailPublisher;
        }

        @Override
        public boolean setRecipients(AbstractProject project, String value) {
            ExtendedEmailPublisher mailer = this.getMailer(project);
            if (!StringUtils.equals((String)value, (String)mailer.recipientList)) {
                mailer.recipientList = value;
                return true;
            }
            return false;
        }

        @Override
        public boolean addMailer(AbstractProject project) throws IOException {
            ExtendedEmailPublisher mailer = this.getMailer(project);
            if (mailer == null) {
                DescribableList publishers = project.getPublishersList();
                ExtendedEmailPublisher publisher = new ExtendedEmailPublisher();
                FailureTrigger trigger = new FailureTrigger();
                EmailType email = new EmailType();
                email.setSendToDevelopers(true);
                email.setSendToRecipientList(true);
                trigger.setEmail(email);
                publisher.getConfiguredTriggers().add(trigger);
                publisher.defaultContent = "$DEFAULT_CONTENT";
                publisher.defaultSubject = "$DEFAULT_SUBJECT";
                publishers.add((Object)publisher);
                return true;
            }
            return false;
        }

        @Override
        public boolean removeMailer(AbstractProject project) throws IOException {
            ExtendedEmailPublisher mailer = this.getMailer(project);
            if (mailer != null) {
                DescribableList publishers = project.getPublishersList();
                publishers.remove((Object)mailer);
                return true;
            }
            return false;
        }
    }
}

