/*
 * Decompiled with CFR 0.152.
 */
package configurationslicing.buildtimeout;

import configurationslicing.UnorderedStringSlicer;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.BuildableItemWithBuildWrappers;
import hudson.model.Describable;
import hudson.model.Hudson;
import hudson.plugins.build_timeout.BuildTimeoutWrapper;
import hudson.util.DescribableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class BuildTimeoutSlicer
extends UnorderedStringSlicer<AbstractProject<?, ?>> {
    public BuildTimeoutSlicer() {
        super(new BuildTimeoutSliceSpec());
    }

    @Override
    public boolean isLoaded() {
        try {
            new BuildTimeoutWrapper(0, false);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BuildTimeoutSliceSpec
    extends UnorderedStringSlicer.UnorderedStringSlicerSpec<AbstractProject<?, ?>> {
        private static final String DISABLED = "(Disabled)";
        private static final String SEPARATOR = ",";

        @Override
        public String getName() {
            return "Build Timeout";
        }

        @Override
        public String getUrl() {
            return "buildtimeout";
        }

        @Override
        public List<AbstractProject<?, ?>> getWorkDomain() {
            return Hudson.getInstance().getItems(BuildableItemWithBuildWrappers.class);
        }

        @Override
        public List<String> getValues(AbstractProject<?, ?> item) {
            BuildableItemWithBuildWrappers bi = (BuildableItemWithBuildWrappers)item;
            DescribableList wrappers = bi.getBuildWrappersList();
            ArrayList<String> values = new ArrayList<String>();
            BuildTimeoutWrapper wrapper = (BuildTimeoutWrapper)wrappers.get(BuildTimeoutWrapper.class);
            if (wrapper != null) {
                String value = wrapper.timeoutMinutes + SEPARATOR + wrapper.failBuild;
                values.add(value);
            }
            if (values.isEmpty()) {
                values.add(DISABLED);
            }
            return values;
        }

        @Override
        public boolean setValues(AbstractProject<?, ?> item, List<String> set) {
            BuildableItemWithBuildWrappers bi = (BuildableItemWithBuildWrappers)item;
            DescribableList wrappers = bi.getBuildWrappersList();
            boolean changed = false;
            BuildTimeoutWrapper wrapper = (BuildTimeoutWrapper)wrappers.get(BuildTimeoutWrapper.class);
            boolean delete = false;
            boolean newFail = false;
            int newTimeout = 0;
            String line = set.iterator().next();
            if (DISABLED.equals(line) || StringUtils.isEmpty((String)line)) {
                delete = true;
            } else {
                String[] split = line.split(SEPARATOR);
                newTimeout = Integer.parseInt(split[0]);
                newFail = Boolean.parseBoolean(split[1]);
            }
            if (wrapper != null) {
                boolean oldFail = wrapper.failBuild;
                int oldTimeout = wrapper.timeoutMinutes;
                if (newFail != oldFail || newTimeout != oldTimeout) {
                    changed = true;
                }
            } else {
                changed = true;
            }
            if (delete) {
                if (wrapper != null) {
                    try {
                        wrappers.remove((Object)wrapper);
                    }
                    catch (IOException e) {
                        System.err.println("IOException Thrown removing wrapper value");
                        return false;
                    }
                }
            } else if (changed) {
                try {
                    wrapper = new BuildTimeoutWrapper(newTimeout, newFail);
                    wrappers.replace((Describable)wrapper);
                }
                catch (IOException e) {
                    System.err.println("IOException Thrown replacing wrapper value");
                    return false;
                }
            }
            return changed;
        }

        @Override
        public String getName(AbstractProject<?, ?> item) {
            return item.getName();
        }

        @Override
        public String getDefaultValueString() {
            return DISABLED;
        }

        @Override
        public String getConfiguredValueDescription() {
            return "Timeout,Fail<br/><i>(e.g. 180,false)</i>";
        }
    }
}

