/*
 * Decompiled with CFR 0.152.
 */
package configurationslicing;

import configurationslicing.Slicer;
import configurationslicing.UnorderedStringSlice;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnorderedStringSlicer<I>
implements Slicer<UnorderedStringSlice<I>, I> {
    private UnorderedStringSlicerSpec<I> spec;

    public UnorderedStringSlicer(UnorderedStringSlicerSpec<I> spec) {
        this.spec = spec;
    }

    @Override
    public UnorderedStringSlice<I> getInitialAccumulator() {
        return new UnorderedStringSlice<I>(this.spec);
    }

    @Override
    public boolean isLoaded() {
        try {
            this.loadPluginDependencyClass();
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public void loadPluginDependencyClass() {
    }

    @Override
    public UnorderedStringSlice<I> accumulate(UnorderedStringSlice<I> t, I item) {
        String name = this.spec.getName(item);
        List<String> values = this.spec.getValues(item);
        if (this.spec.isIndexUsed(values.size())) {
            for (int i = 0; i < values.size(); ++i) {
                ArrayList<String> oneValueList = new ArrayList<String>();
                oneValueList.add(values.get(i));
                String valueIndex = this.spec.getValueIndex(item, i);
                String oneName = name + "[" + valueIndex + "]";
                t.add(oneName, oneValueList);
            }
        } else {
            t.add(this.spec.getName(item), values);
        }
        return t;
    }

    @Override
    public boolean transform(UnorderedStringSlice<I> t, I i) {
        List<String> set = t.get(this.spec.getName(i));
        if (set == null) {
            return false;
        }
        return this.spec.setValues(i, set);
    }

    @Override
    public String getName() {
        return this.spec.getName();
    }

    @Override
    public String getUrl() {
        return this.spec.getUrl();
    }

    @Override
    public List<I> getWorkDomain() {
        return this.spec.getWorkDomain();
    }

    @Override
    public int compareTo(Slicer<UnorderedStringSlice<I>, I> o) {
        return this.getName().compareToIgnoreCase(o.getName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class UnorderedStringSlicerSpec<I> {
        public abstract String getName();

        public abstract String getUrl();

        public abstract List<I> getWorkDomain();

        public abstract List<String> getValues(I var1);

        public abstract String getName(I var1);

        public abstract boolean setValues(I var1, List<String> var2);

        public abstract String getDefaultValueString();

        public List<String> getCommonValueStrings() {
            return null;
        }

        public String getConfiguredValueDescription() {
            return "Configured Value";
        }

        public boolean isIndexUsed(int count) {
            return false;
        }

        public String getValueIndex(I item, int index) {
            return String.valueOf(index);
        }

        public int getValueIndex(I item, String indexName) {
            return Integer.parseInt(indexName);
        }

        public boolean isBlankNeededForValues() {
            return true;
        }
    }
}

