/*
 * Decompiled with CFR 0.152.
 */
package configurationslicing;

import configurationslicing.Slice;
import configurationslicing.Slicer;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.ManagementLink;
import hudson.model.View;
import hudson.model.ViewGroup;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletException;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class ConfigurationSlicing
extends ManagementLink {
    public String getDescription() {
        return "Configure a single aspect across a group of items, in contrast to the traditional configuration of all aspects of a single item";
    }

    public String getIconFileName() {
        return "orange-square.gif";
    }

    public String getUrlName() {
        return "slicing";
    }

    public String getDisplayName() {
        return "Configuration Slicing";
    }

    public List<Slicer> getAxes() {
        ExtensionList elist = Hudson.getInstance().getExtensionList(Slicer.class);
        ArrayList<Slicer> list = new ArrayList<Slicer>();
        for (Slicer slicer : elist) {
            if (!slicer.isLoaded()) continue;
            list.add(slicer);
        }
        Collections.sort(list);
        return list;
    }

    public Collection<String> getViews() {
        Collection views = Hudson.getInstance().getViews();
        ArrayList<String> names = new ArrayList<String>();
        this.addViews(null, views, names);
        Collections.sort(names, String.CASE_INSENSITIVE_ORDER);
        return names;
    }

    private void addViews(String baseName, Collection<View> views, List<String> names) {
        for (View view : views) {
            String name = view.getDisplayName();
            if (baseName != null) {
                name = baseName + "/" + name;
            }
            if (view instanceof ViewGroup) {
                ViewGroup group = (ViewGroup)view;
                Collection subviews = group.getViews();
                this.addViews(name, subviews, names);
                continue;
            }
            names.add(name);
        }
    }

    public Object getDynamic(String token, StaplerRequest req, StaplerResponse rsp) {
        Hudson.getInstance().checkPermission(Hudson.ADMINISTER);
        for (Slicer s : this.getAxes()) {
            if (!s.getUrl().equals(token)) continue;
            return new SliceExecutor(s, null);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SliceExecutor<T extends Slice, I> {
        Slicer<T, I> slicer;
        List<I> worklist;
        List<I> changed;
        T slice;
        View view;

        public SliceExecutor(Slicer<T, I> s, View view) {
            this.slicer = s;
            this.view = view;
            this.execute();
        }

        private void execute() {
            Slice accumulator = (Slice)this.slicer.getInitialAccumulator();
            this.worklist = this.slicer.getWorkDomain();
            Collection items = null;
            if (this.view != null) {
                items = this.view.getItems();
            }
            for (I item : this.worklist) {
                if (items != null && !items.contains(item)) continue;
                accumulator = this.slicer.accumulate(accumulator, item);
            }
            this.slice = accumulator;
        }

        private List<I> transform(T newslice) {
            ArrayList<I> ret = new ArrayList<I>();
            this.worklist = this.slicer.getWorkDomain();
            for (I item : this.worklist) {
                if (!this.slicer.transform(newslice, item)) continue;
                ret.add(item);
            }
            return ret;
        }

        public ConfigurationSlicing getParent() {
            return ConfigurationSlicing.this;
        }

        public T getSlice() {
            return this.slice;
        }

        public Slicer<T, I> getSlicer() {
            return this.slicer;
        }

        public List<I> getChanged() {
            return this.changed;
        }

        public String getViewDisplayPart() {
            if (this.view == null) {
                return "";
            }
            String part = this.view.getDisplayName();
            ViewGroup owner = this.view.getOwner();
            while (owner instanceof View) {
                View parentView = (View)owner;
                part = parentView.getDisplayName() + " / " + part;
                owner = parentView.getOwner();
            }
            part = " > " + part;
            return part;
        }

        public List<I> getWorklist() {
            return this.worklist;
        }

        public void doSliceconfigSubmit(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            String pathInfo = req.getPathInfo();
            try {
                Slice newslice = ((Slice)this.slice).newInstance(req, req.getSubmittedForm());
                this.transform(newslice);
                this.slice = newslice;
                String redirect = this.getRedirectPath(pathInfo);
                rsp.sendRedirect2(redirect);
            }
            catch (Descriptor.FormException e) {
                e.printStackTrace();
            }
        }

        private String getRedirectPath(String pathInfo) {
            String urlPart = "slicing/" + this.slicer.getUrl() + "/view/";
            if (pathInfo.contains(urlPart)) {
                return "../..";
            }
            return "..";
        }

        public Object getDynamic(String token, StaplerRequest req, StaplerResponse rsp) {
            Hudson.getInstance().checkPermission(Hudson.ADMINISTER);
            String viewName = req.getParameter("view");
            View view = null;
            if (viewName != null) {
                view = this.getView(viewName);
            }
            return new SliceExecutor<T, I>(this.slicer, view);
        }

        private View getView(String token) {
            String[] split = token.split("/");
            View view = null;
            for (String name : split) {
                view = view instanceof ViewGroup ? ((ViewGroup)view).getView(name) : Hudson.getInstance().getView(name);
            }
            return view;
        }
    }
}

