/*
 * Decompiled with CFR 0.152.
 */
package configurationslicing;

import configurationslicing.Slicer;
import configurationslicing.UnorderedStringSlice;
import configurationslicing.UnorderedStringSlicer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnorderedStringSlicer<I>
implements Slicer<UnorderedStringSlice<I>, I> {
    private UnorderedStringSlicerSpec<I> spec;

    public UnorderedStringSlicer(UnorderedStringSlicerSpec<I> spec) {
        this.spec = spec;
    }

    public UnorderedStringSlice<I> getInitialAccumulator() {
        return new UnorderedStringSlice(this.spec);
    }

    public boolean isLoaded() {
        try {
            this.loadPluginDependencyClass();
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public void loadPluginDependencyClass() {
    }

    public UnorderedStringSlice<I> accumulate(UnorderedStringSlice<I> t, I item) {
        String name = this.spec.getName(item);
        List values = this.spec.getValues(item);
        if (this.spec.isIndexUsed(values.size())) {
            for (int i = 0; i < values.size(); ++i) {
                ArrayList oneValueList = new ArrayList();
                oneValueList.add(values.get(i));
                String valueIndex = this.spec.getValueIndex(item, i);
                String oneName = name + "[" + valueIndex + "]";
                t.add(oneName, oneValueList);
            }
        } else {
            t.add(this.spec.getName(item), (Collection)values);
        }
        return t;
    }

    public boolean transform(UnorderedStringSlice<I> t, I i) {
        List set = t.get(this.spec.getName(i));
        if (set == null) {
            return false;
        }
        return this.spec.setValues(i, set);
    }

    public String getName() {
        return this.spec.getName();
    }

    public String getUrl() {
        return this.spec.getUrl();
    }

    public List<I> getWorkDomain() {
        return this.spec.getWorkDomain();
    }

    public int compareTo(Slicer<UnorderedStringSlice<I>, I> o) {
        return this.getName().compareToIgnoreCase(o.getName());
    }
}

