/*
 * Decompiled with CFR 0.152.
 */
package configurationslicing;

import configurationslicing.Slice;
import configurationslicing.UnorderedStringSlicer;
import hudson.model.Descriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class UnorderedStringSlice<I>
extends Slice {
    private Map<String, List<String>> nameToValues;
    private Map<String, Set<String>> valueToNames = new HashMap();
    private UnorderedStringSlicer.UnorderedStringSlicerSpec<I> spec;

    public UnorderedStringSlice(UnorderedStringSlicer.UnorderedStringSlicerSpec<I> spec, List<String> configurationValues, List<String> itemNames) {
        this(spec);
        this.nameToValues = new HashMap();
        for (int i = 0; i < configurationValues.size(); ++i) {
            String value = configurationValues.get(i);
            String namesString = itemNames.get(i);
            String[] namesSplit = namesString.split("\\n");
            List workDomain = spec.getWorkDomain();
            for (String itemName : namesSplit) {
                if ((itemName = itemName.trim()).length() <= 0) continue;
                int index = 0;
                int bracket = itemName.indexOf(91);
                if (bracket > 0) {
                    String indexString = itemName.substring(bracket + 1, itemName.length() - 1);
                    itemName = itemName.substring(0, bracket);
                    Object item = this.getItem(itemName, workDomain);
                    index = spec.getValueIndex(item, indexString);
                }
                UnorderedStringSlice.addLine((Map)this.nameToValues, (String)itemName, (String)value.trim(), (int)index);
            }
        }
    }

    public I getItem(String name, List<I> workDomain) {
        for (I item : workDomain) {
            if (!name.equals(this.spec.getName(item))) continue;
            return item;
        }
        throw new IllegalArgumentException(name);
    }

    public UnorderedStringSlice(UnorderedStringSlicer.UnorderedStringSlicerSpec<I> spec) {
        this.spec = spec;
    }

    public void add(String name, Collection<String> values) {
        for (String value : values) {
            UnorderedStringSlice.addLineWithSets((Map)this.valueToNames, (String)value, (String)name);
        }
    }

    private static void addLineWithSets(Map<String, Set<String>> map, String s, String name) {
        if (!map.containsKey(s)) {
            map.put(s, new HashSet());
        }
        Set<String> list = map.get(s);
        list.add(name);
    }

    private static void addLine(Map<String, List<String>> map, String s, String name, int index) {
        if (!map.containsKey(s)) {
            map.put(s, new ArrayList());
        }
        List<String> list = map.get(s);
        while (list.size() < index + 1) {
            list.add("");
        }
        list.set(index, name);
    }

    public List<String> get(String name) {
        return (List)this.nameToValues.get(name);
    }

    public UnorderedStringSlicer.UnorderedStringSlicerSpec<I> getSpec() {
        return this.spec;
    }

    public List<String> getConfiguredValues() {
        String defaultValueString = this.spec.getDefaultValueString();
        ArrayList<String> list = new ArrayList<String>(this.valueToNames.keySet());
        if (list.contains(defaultValueString)) {
            list.remove(defaultValueString);
        }
        Collections.sort(list, String.CASE_INSENSITIVE_ORDER);
        List commonValues = this.spec.getCommonValueStrings();
        if (commonValues != null) {
            for (String commonValue : commonValues) {
                if (list.contains(commonValue)) continue;
                list.add(commonValue);
            }
        }
        if (defaultValueString != null) {
            list.add(defaultValueString);
        }
        if (this.spec.isBlankNeededForValues() && !list.contains("")) {
            list.add("");
        }
        return list;
    }

    public String getItemNamesString(String configurationString) {
        List list = this.getItemNames(configurationString);
        StringBuilder buf = new StringBuilder();
        for (String job : list) {
            buf.append(job);
            buf.append("\n");
        }
        return buf.toString();
    }

    public List<String> getItemNames(String configurationString) {
        Set set = (Set)this.valueToNames.get(configurationString);
        if (set == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> list = new ArrayList<String>(set);
        Collections.sort(list, String.CASE_INSENSITIVE_ORDER);
        return list;
    }

    public Slice newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
        return new UnorderedStringSlice(this.spec, this.getStringList(formData, "configValue"), this.getStringList(formData, "itemNames"));
    }

    private List<String> getStringList(JSONObject formData, String key) {
        JSONArray array = formData.getJSONArray(key);
        ArrayList<String> list = new ArrayList<String>();
        for (Object o : array) {
            list.add((String)o);
        }
        return list;
    }
}

