/*
 * Decompiled with CFR 0.152.
 */
package configurationslicing;

import configurationslicing.ConfigurationSlicing;
import configurationslicing.Slicer;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Hudson;
import hudson.model.ManagementLink;
import hudson.model.View;
import hudson.model.ViewGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class ConfigurationSlicing
extends ManagementLink {
    public String getDescription() {
        return "Configure a single aspect across a group of items, in contrast to the traditional configuration of all aspects of a single item";
    }

    public String getIconFileName() {
        return "orange-square.gif";
    }

    public String getUrlName() {
        return "slicing";
    }

    public String getDisplayName() {
        return "Configuration Slicing";
    }

    public List<Slicer> getAxes() {
        ExtensionList elist = Hudson.getInstance().getExtensionList(Slicer.class);
        ArrayList<Slicer> list = new ArrayList<Slicer>();
        for (Slicer slicer : elist) {
            if (!slicer.isLoaded()) continue;
            list.add(slicer);
        }
        Collections.sort(list);
        return list;
    }

    public Collection<String> getViews() {
        Collection views = Hudson.getInstance().getViews();
        ArrayList<String> names = new ArrayList<String>();
        this.addViews(null, views, names);
        Collections.sort(names, String.CASE_INSENSITIVE_ORDER);
        return names;
    }

    private void addViews(String baseName, Collection<View> views, List<String> names) {
        for (View view : views) {
            String name = view.getDisplayName();
            if (baseName != null) {
                name = baseName + "/" + name;
            }
            if (view instanceof ViewGroup) {
                ViewGroup group = (ViewGroup)view;
                Collection subviews = group.getViews();
                this.addViews(name, subviews, names);
                continue;
            }
            names.add(name);
        }
    }

    public Object getDynamic(String token, StaplerRequest req, StaplerResponse rsp) {
        Hudson.getInstance().checkPermission(Hudson.ADMINISTER);
        for (Slicer s : this.getAxes()) {
            if (!s.getUrl().equals(token)) continue;
            return new SliceExecutor(this, s, null);
        }
        return null;
    }
}

