/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.kubernetes.auth.impl;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.util.Secret;
import io.fabric8.kubernetes.api.model.AuthInfoBuilder;
import io.fabric8.kubernetes.client.ConfigBuilder;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateEncodingException;
import org.jenkinsci.plugins.kubernetes.auth.KubernetesAuthConfig;
import org.jenkinsci.plugins.kubernetes.auth.KubernetesAuthException;
import org.jenkinsci.plugins.kubernetes.auth.impl.AbstractKubernetesAuth;
import org.jenkinsci.plugins.kubernetes.credentials.Utils;

public class KubernetesAuthKeystore
extends AbstractKubernetesAuth {
    private final Secret passPhrase;
    private KeyStore keyStore;

    public KubernetesAuthKeystore(@NonNull KeyStore keyStore, Secret passPhrase) {
        this.keyStore = keyStore;
        this.passPhrase = passPhrase;
    }

    public KubernetesAuthKeystore(@NonNull KeyStore keyStore, String passPhrase) {
        this(keyStore, Secret.fromString((String)passPhrase));
    }

    @Override
    public AuthInfoBuilder decorate(AuthInfoBuilder builder, KubernetesAuthConfig config) throws KubernetesAuthException {
        try {
            String alias = this.keyStore.aliases().nextElement();
            Key key = this.keyStore.getKey(alias, this.passPhrase.getPlainText().toCharArray());
            return (AuthInfoBuilder)((AuthInfoBuilder)builder.withClientCertificateData(Utils.encodeCertificate(this.keyStore.getCertificate(alias)))).withClientKeyData(Utils.encodeKey(key));
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateEncodingException e) {
            throw new KubernetesAuthException(e.getMessage(), e);
        }
    }

    @Override
    public ConfigBuilder decorate(ConfigBuilder builder, KubernetesAuthConfig config) throws KubernetesAuthException {
        try {
            String alias = this.keyStore.aliases().nextElement();
            Key key = this.keyStore.getKey(alias, this.passPhrase.getPlainText().toCharArray());
            return (ConfigBuilder)((ConfigBuilder)builder.withClientCertData(Utils.encodeCertificate(this.keyStore.getCertificate(alias)))).withClientKeyData(Utils.encodeKey(key));
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateEncodingException e) {
            throw new KubernetesAuthException(e.getMessage(), e);
        }
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    @Deprecated
    public String getPassPhrase() {
        return this.passPhrase.getPlainText();
    }

    public Secret getPassPhraseSecret() {
        return this.passPhrase;
    }
}

