/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.maven.plugins.hpi;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.jenkinsci.maven.plugins.hpi.AbstractHpiMojo;
import org.jenkinsci.maven.plugins.hpi.MavenArtifact;

@Mojo(name="resolve-test-dependencies", requiresDependencyResolution=ResolutionScope.TEST)
public class TestDependencyMojo
extends AbstractHpiMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        File testDir = new File(this.project.getBuild().getTestOutputDirectory(), "test-dependencies");
        try {
            Files.createDirectories(testDir.toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to create directories for '" + testDir + "'", (Exception)e);
        }
        try (FileOutputStream fos = new FileOutputStream(new File(testDir, "index"));
             OutputStreamWriter w = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);){
            for (MavenArtifact a : this.getProjectArtfacts()) {
                if (!a.isPluginBestEffort(this.getLog())) continue;
                String artifactId = a.getActualArtifactId();
                if (artifactId == null) {
                    this.getLog().debug((CharSequence)("Skipping " + artifactId + " with classifier " + a.getClassifier()));
                    continue;
                }
                this.getLog().debug((CharSequence)("Copying " + artifactId + " as a test dependency"));
                File dst = new File(testDir, artifactId + ".hpi");
                FileUtils.copyFile((File)a.getHpi().getFile(), (File)dst);
                w.write(artifactId + "\n");
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to copy dependency plugins", (Exception)e);
        }
    }
}

