/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.maven.plugins.hpi;

import hudson.util.VersionNumber;
import io.jenkins.lib.versionnumber.JavaSpecificationVersion;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.jenkinsci.maven.plugins.hpi.AbstractJenkinsMojo;

@Mojo(name="initialize", defaultPhase=LifecyclePhase.INITIALIZE)
public class InitializeMojo
extends AbstractJenkinsMojo {
    public void execute() throws MojoExecutionException {
        this.setCompilerProperties();
    }

    private void setCompilerProperties() throws MojoExecutionException {
        if (!this.project.getProperties().containsKey("maven.compiler.source") && !this.project.getProperties().containsKey("maven.compiler.release")) {
            return;
        }
        JavaSpecificationVersion javaVersion = this.getMinimumJavaVersion();
        if (JavaSpecificationVersion.forCurrentJVM().isOlderThan(new VersionNumber("9"))) {
            this.setProperty("maven.compiler.source", javaVersion.toString());
            this.setProperty("maven.compiler.target", javaVersion.toString());
            this.setProperty("maven.compiler.testSource", javaVersion.toString());
            this.setProperty("maven.compiler.testTarget", javaVersion.toString());
            this.unsetProperty("maven.compiler.release");
            this.unsetProperty("maven.compiler.testRelease");
        } else {
            this.setProperty("maven.compiler.release", Integer.toString(javaVersion.toReleaseVersion()));
            this.setProperty("maven.compiler.testRelease", Integer.toString(javaVersion.toReleaseVersion()));
            this.setProperty("animal.sniffer.skip", "true");
            this.unsetProperty("maven.compiler.source");
            this.unsetProperty("maven.compiler.target");
            this.unsetProperty("maven.compiler.testSource");
            this.unsetProperty("maven.compiler.testTarget");
        }
    }

    private void setProperty(String key, String value) {
        String currentValue = this.project.getProperties().getProperty(key);
        if (currentValue == null || !currentValue.equals(value)) {
            this.getLog().info((CharSequence)("Setting " + key + " to " + value));
            this.project.getProperties().setProperty(key, value);
        }
    }

    private void unsetProperty(String key) {
        if (this.project.getProperties().containsKey(key)) {
            this.getLog().info((CharSequence)("Unsetting " + key));
            this.project.getProperties().remove(key);
        }
    }
}

