/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.maven.plugins.hpi;

import java.io.File;
import java.io.IOException;
import java.util.Objects;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.Manifest;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.jenkinsci.maven.plugins.hpi.AbstractJenkinsManifestMojo;

@Mojo(name="hpi", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class HpiMojo
extends AbstractJenkinsManifestMojo {
    @Parameter(defaultValue="${project.build.finalName}")
    private String hpiName;
    @Parameter(defaultValue="")
    private String jarClassifier;
    @Component(role=Archiver.class, hint="jar")
    private JarArchiver jarArchiver;
    @Component(role=Archiver.class, hint="jar")
    private JarArchiver hpiArchiver;
    @Parameter
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();

    protected File getOutputFile(String extension) {
        return new File(new File(this.outputDirectory), this.hpiName + extension);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.performPackaging();
        }
        catch (IOException | DependencyResolutionRequiredException | ArchiverException | ManifestException e) {
            throw new MojoExecutionException("Error assembling hpi: " + e.getMessage(), (Exception)e);
        }
    }

    private void performPackaging() throws IOException, ArchiverException, ManifestException, DependencyResolutionRequiredException, MojoExecutionException, MojoFailureException {
        File manifestFile = new File(this.getWebappDirectory(), "META-INF/MANIFEST.MF");
        this.generateManifest(this.archive, manifestFile);
        Manifest manifest = this.loadManifest(manifestFile);
        this.getLog().info((CharSequence)("Checking for attached .jar artifact " + (this.jarClassifier == null || this.jarClassifier.trim().isEmpty() ? "..." : "with classifier " + this.jarClassifier + "...")));
        File jarFile = null;
        for (Artifact artifact : this.project.getAttachedArtifacts()) {
            if (!Objects.equals(this.project.getGroupId(), artifact.getGroupId()) || !Objects.equals(this.project.getArtifactId(), artifact.getArtifactId()) || !this.project.getArtifact().getVersionRange().equals((Object)artifact.getVersionRange()) || !Objects.equals("jar", artifact.getType()) || !(this.jarClassifier == null || this.jarClassifier.trim().isEmpty() ? !artifact.hasClassifier() : Objects.equals(this.jarClassifier, artifact.getClassifier())) || artifact.getFile() == null || !artifact.getFile().isFile()) continue;
            jarFile = artifact.getFile();
            this.getLog().info((CharSequence)("Found attached .jar artifact: " + jarFile.getAbsolutePath()));
            break;
        }
        if (jarFile == null) {
            jarFile = this.getOutputFile(".jar");
            this.getLog().info((CharSequence)("Generating jar " + jarFile.getAbsolutePath()));
            MavenArchiver archiver = new MavenArchiver();
            archiver.setArchiver(this.jarArchiver);
            archiver.setOutputFile(jarFile);
            this.jarArchiver.addConfiguredManifest(manifest);
            File indexJelly = new File(this.getClassesDirectory(), "index.jelly");
            if (!indexJelly.isFile()) {
                throw new MojoFailureException("Missing " + indexJelly + ". Delete any <description> from pom.xml and create src/main/resources/index.jelly:\n<?jelly escape-by-default='true'?>\n<div>\n    The description here\u2026\n</div>");
            }
            this.jarArchiver.addDirectory(this.getClassesDirectory());
            archiver.createArchive(this.session, this.project, this.archive);
        }
        this.projectHelper.attachArtifact(this.project, "jar", null, jarFile);
        this.buildExplodedWebapp(this.getWebappDirectory(), jarFile);
        File hpiFile = this.getOutputFile(".hpi");
        this.getLog().info((CharSequence)("Generating hpi " + hpiFile.getAbsolutePath()));
        MavenArchiver archiver = new MavenArchiver();
        archiver.setArchiver(this.hpiArchiver);
        archiver.setOutputFile(hpiFile);
        this.hpiArchiver.addConfiguredManifest(manifest);
        this.hpiArchiver.addDirectory(this.getWebappDirectory(), this.getIncludes(), this.getExcludes());
        archiver.createArchive(this.session, this.project, this.archive);
        this.project.getArtifact().setFile(hpiFile);
    }
}

