/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.maven.plugins.hpi;

import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocComment;
import com.sun.codemodel.JJavaName;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JResourceFile;
import com.sun.codemodel.fmt.JBinaryFile;
import com.sun.codemodel.writer.FileCodeWriter;
import com.sun.codemodel.writer.FilterCodeWriter;
import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;
import org.jenkinsci.maven.plugins.hpi.ReservedName;
import org.kohsuke.stapler.jelly.groovy.TagFile;
import org.kohsuke.stapler.jelly.groovy.TagLibraryUri;
import org.kohsuke.stapler.jelly.groovy.TypedTagLibrary;

@Mojo(name="generate-taglib-interface", defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class TagLibInterfaceGeneratorMojo
extends AbstractMojo {
    @Component
    protected MavenProject project;
    @Parameter(defaultValue="${project.basedir}/target/generated-sources/taglib-interface")
    protected File outputDirectory;
    @Parameter(property="project.build.sourceEncoding")
    protected String encoding;
    private SAXReader saxReader = new SAXReader();

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            JCodeModel codeModel = new JCodeModel();
            for (Resource res : this.project.getBuild().getResources()) {
                this.walk(new File(res.getDirectory()), codeModel.rootPackage(), "");
            }
            this.outputDirectory.mkdirs();
            FilterCodeWriter w = new FilterCodeWriter((CodeWriter)(this.encoding != null ? new FileCodeWriter(this.outputDirectory, this.encoding) : new FileCodeWriter(this.outputDirectory))){

                public Writer openSource(JPackage pkg, String fileName) throws IOException {
                    this.report(pkg, fileName);
                    return super.openSource(pkg, fileName);
                }

                public OutputStream openBinary(JPackage pkg, String fileName) throws IOException {
                    this.report(pkg, fileName);
                    return super.openBinary(pkg, fileName);
                }

                private void report(JPackage pkg, String fileName) {
                    if (pkg.isUnnamed()) {
                        TagLibInterfaceGeneratorMojo.this.getLog().info((CharSequence)fileName);
                    } else {
                        TagLibInterfaceGeneratorMojo.this.getLog().info((CharSequence)(pkg.name().replace('.', File.separatorChar) + File.separatorChar + fileName));
                    }
                }
            };
            codeModel.build((CodeWriter)w);
            this.project.getCompileSourceRoots().add(this.outputDirectory.getAbsolutePath());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to generate taglib type interface", (Exception)e);
        }
        catch (JClassAlreadyExistsException e) {
            throw new MojoExecutionException("Duplicate class: " + e.getExistingClass().fullName(), (Exception)((Object)e));
        }
    }

    private void walk(File dir, JPackage pkg, String dirName) throws JClassAlreadyExistsException, IOException {
        File[] children = dir.listFiles(File::isDirectory);
        if (children != null) {
            for (File child : children) {
                this.walk(child, pkg.subPackage(TagLibInterfaceGeneratorMojo.h2j(child.getName())), dirName + '/' + child.getName());
            }
        }
        if (this.isTagLibDir(dir)) {
            JDefinedClass c = pkg.parent()._interface(StringUtils.capitalize((String)TagLibInterfaceGeneratorMojo.h2j(dir.getName())) + "TagLib");
            c._implements(TypedTagLibrary.class);
            c.annotate(TagLibraryUri.class).param("value", dirName);
            JBinaryFile _gdsl = new JBinaryFile(c.name() + ".gdsl");
            PrintWriter gdsl = new PrintWriter(_gdsl.getDataStore());
            gdsl.printf("package %s;\n", pkg.parent().name());
            gdsl.printf("contributor(context(ctype:'%s')) {\n", c.fullName());
            File[] tags = dir.listFiles((unused, name) -> name.endsWith(".jelly"));
            long timestamp = -1L;
            for (File tag : tags) {
                timestamp = Math.max(tag.lastModified(), timestamp);
                try {
                    String methodName;
                    Document dom = this.saxReader.read(tag);
                    Element doc = dom.getRootElement().element(QName.get((String)"st:documentation", (String)"jelly:stapler"));
                    String baseName = FilenameUtils.getBaseName((String)tag.getName());
                    if (!JJavaName.isJavaIdentifier((String)tag.getName())) {
                        methodName = baseName.replace('-', '_');
                        if (ReservedName.NAMES.contains(methodName)) {
                            methodName = methodName + '_';
                        }
                    } else {
                        methodName = baseName;
                    }
                    for (int i = 0; i < 4; ++i) {
                        JMethod m = c.method(0, Void.TYPE, methodName);
                        if (!methodName.equals(baseName)) {
                            m.annotate(TagFile.class).param("value", baseName);
                        }
                        if (i % 2 == 0) {
                            m.param(Map.class, "args");
                        }
                        if (i / 2 % 2 == 0) {
                            m.param(Closure.class, "body");
                        }
                        JDocComment javadoc = m.javadoc();
                        if (doc == null) continue;
                        javadoc.append((Object)doc.getText().replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;"));
                    }
                    if (doc == null) continue;
                    gdsl.printf("  method name:'%s', type:void, params:[args:[\n", methodName);
                    List atts = doc.elements(QName.get((String)"st:attribute", (String)"jelly:stapler"));
                    for (Element a : atts) {
                        gdsl.printf("    parameter(name:'%s',type:'%s', doc:\"\"\"\n%s\n\"\"\"),\n", a.attributeValue("name"), a.attributeValue("type", "java.lang.Object"), a.getTextTrim().replace("$", "\\$").replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;"));
                    }
                    gdsl.printf("  ], dummy:void, c:Closure]\n", new Object[0]);
                }
                catch (DocumentException e) {
                    throw new IOException("Failed to parse " + tag, e);
                }
            }
            gdsl.printf("}\n", new Object[0]);
            gdsl.close();
            File dst = new File(this.outputDirectory, c.fullName().replace('.', '/') + ".java");
            if (dst.exists() && dst.lastModified() > timestamp) {
                c.hide();
            } else {
                pkg.parent().addResourceFile((JResourceFile)_gdsl);
            }
        }
    }

    private boolean isTagLibDir(File dir) {
        return new File(dir, "taglib").exists();
    }

    private static String h2j(String s) {
        if (s.equals("hudson")) {
            return "jenkins";
        }
        return s;
    }
}

