/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.maven.plugins.hpi;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;

public final class PropertyUtils {
    private PropertyUtils() {
    }

    public static Properties loadPropertyFile(File propfile, boolean fail, boolean useSystemProps) throws IOException {
        Properties props = new Properties();
        if (useSystemProps) {
            props = new Properties(System.getProperties());
        }
        if (propfile.exists()) {
            try (FileInputStream inStream = new FileInputStream(propfile);){
                props.load(inStream);
            }
        } else if (fail) {
            throw new FileNotFoundException(propfile.toString());
        }
        Enumeration<?> n = props.propertyNames();
        while (n.hasMoreElements()) {
            String k = (String)n.nextElement();
            props.setProperty(k, PropertyUtils.getPropertyValue(k, props));
        }
        return props;
    }

    private static String getPropertyValue(String k, Properties p) {
        int idx;
        String v = p.getProperty(k);
        String ret = "";
        while ((idx = v.indexOf("${")) >= 0) {
            ret = ret + v.substring(0, idx);
            int idx2 = (v = v.substring(idx + 2)).indexOf(125);
            if (idx2 < 0) break;
            String nk = v.substring(0, idx2);
            v = v.substring(idx2 + 1);
            String nv = p.getProperty(nk);
            if (nv == null) {
                nv = System.getProperty(nk);
            }
            if (nv == null || nv.equals(k)) {
                ret = ret + "${" + nk + "}";
                continue;
            }
            v = nv + v;
        }
        return ret + v;
    }
}

