/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.maven.plugins.hpi;

import hudson.util.VersionNumber;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.jar.JarFile;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolverException;

public class MavenArtifact
implements Comparable<MavenArtifact> {
    public final ArtifactFactory artifactFactory;
    public final MavenProjectBuilder builder;
    public final List<ArtifactRepository> remoteRepositories;
    public final ArtifactRepository localRepository;
    public final Artifact artifact;
    public final ArtifactResolver resolver;
    public final MavenSession session;

    public MavenArtifact(Artifact artifact, ArtifactResolver resolver, ArtifactFactory artifactFactory, MavenProjectBuilder builder, List<ArtifactRepository> remoteRepositories, ArtifactRepository localRepository, MavenSession session) {
        this.artifact = artifact;
        this.resolver = resolver;
        this.artifactFactory = artifactFactory;
        this.builder = builder;
        this.remoteRepositories = Objects.requireNonNull(remoteRepositories);
        this.localRepository = localRepository;
        this.session = Objects.requireNonNull(session);
    }

    public MavenProject resolvePom() throws ProjectBuildingException {
        return this.builder.buildFromRepository(this.artifact, this.remoteRepositories, this.localRepository);
    }

    public boolean isPlugin() throws IOException {
        String type = this.getResolvedType();
        return type.equals("hpi") || type.equals("jpi");
    }

    public boolean isPluginBestEffort(Log log) {
        try {
            return this.isPlugin();
        }
        catch (IOException x) {
            if (log.isDebugEnabled()) {
                log.debug((Throwable)x);
            } else {
                log.warn((CharSequence)x.getCause().getMessage());
            }
            return false;
        }
    }

    public String getId() {
        return this.artifact.getId();
    }

    public String getDefaultFinalName() {
        return this.artifact.getArtifactId() + "-" + this.artifact.getVersion() + "." + this.artifact.getArtifactHandler().getExtension();
    }

    public boolean isOptional() {
        return this.artifact.isOptional();
    }

    public String getType() {
        return this.artifact.getType();
    }

    public File getFile() {
        if (this.artifact.getFile() == null) {
            try {
                DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
                buildingRequest.setRemoteRepositories(this.remoteRepositories);
                buildingRequest.setLocalRepository(this.localRepository);
                return this.resolver.resolveArtifact((ProjectBuildingRequest)buildingRequest, this.artifact).getArtifact().getFile();
            }
            catch (ArtifactResolverException e) {
                throw new RuntimeException("Failed to resolve " + this.getId(), e);
            }
        }
        return this.artifact.getFile();
    }

    public MavenArtifact getHpi() throws IOException {
        Artifact a = this.artifactFactory.createArtifact(this.artifact.getGroupId(), this.artifact.getArtifactId(), this.artifact.getVersion(), "compile", this.getResolvedType());
        return new MavenArtifact(a, this.resolver, this.artifactFactory, this.builder, this.remoteRepositories, this.localRepository, this.session);
    }

    public List<String> getDependencyTrail() {
        return this.artifact.getDependencyTrail();
    }

    public String getGroupId() {
        return this.artifact.getGroupId();
    }

    public String getScope() {
        return this.artifact.getScope();
    }

    public boolean hasScope(String ... scopes) {
        for (String s : scopes) {
            if (s == null && this.artifact.getScope() == null) {
                return true;
            }
            if (s == null || !s.equals(this.artifact.getScope())) continue;
            return true;
        }
        return false;
    }

    public String getArtifactId() {
        return this.artifact.getArtifactId();
    }

    public String getVersion() {
        return this.artifact.getVersion();
    }

    public String getClassifier() {
        return this.artifact.getClassifier();
    }

    public String getActualArtifactId() throws IOException {
        File file = this.getFile();
        if (file != null && file.isFile()) {
            try (JarFile jf = new JarFile(file);){
                String string = jf.getManifest().getMainAttributes().getValue("Short-Name");
                return string;
            }
        }
        return this.getArtifactId();
    }

    public String getActualVersion() throws IOException {
        File file = this.getFile();
        if (file != null && file.isFile()) {
            try (JarFile jf = new JarFile(file);){
                String string = jf.getManifest().getMainAttributes().getValue("Plugin-Version").replaceFirst(" [(].+[)]$", "");
                return string;
            }
        }
        return this.getVersion();
    }

    public ArtifactVersion getVersionNumber() throws OverConstrainedVersionException {
        return this.artifact.getSelectedVersion();
    }

    public boolean hasSameGAAs(MavenProject project) {
        return this.getGroupId().equals(project.getGroupId()) && this.getArtifactId().equals(project.getArtifactId());
    }

    public boolean isNewerThan(MavenArtifact rhs) {
        return new VersionNumber(this.getVersion()).compareTo(new VersionNumber(rhs.getVersion())) > 0;
    }

    public String toString() {
        return this.getId();
    }

    @Override
    public int compareTo(MavenArtifact o) {
        return this.getId().compareTo(o.getId());
    }

    private String getResolvedType() throws IOException {
        try {
            String type = this.artifact.getType();
            if (!type.equals("jar")) {
                return type;
            }
            if (!StringUtils.isEmpty((String)this.artifact.getClassifier())) {
                return type;
            }
            return this.resolvePom().getPackaging();
        }
        catch (ProjectBuildingException e) {
            throw new IOException("Failed to open artifact " + this.artifact + " at " + this.artifact.getFile() + ": " + (Object)((Object)e), e);
        }
    }
}

