/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.maven.plugins.hpi;

import com.google.common.collect.Sets;
import hudson.Extension;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.YesNoMaybe;
import net.java.sezpoz.Index;
import net.java.sezpoz.IndexItem;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.InterpolationFilterReader;
import org.codehaus.plexus.util.StringUtils;
import org.jenkinsci.maven.plugins.hpi.AbstractJenkinsMojo;
import org.jenkinsci.maven.plugins.hpi.Artifacts;
import org.jenkinsci.maven.plugins.hpi.MavenArtifact;
import org.jenkinsci.maven.plugins.hpi.PropertyUtils;

public abstract class AbstractHpiMojo
extends AbstractJenkinsMojo {
    @Parameter(defaultValue="${project.build.directory}")
    protected String outputDirectory;
    @Parameter(defaultValue="${project.build.outputDirectory}")
    private File classesDirectory;
    @Parameter(defaultValue="${project.name}", readonly=true)
    protected String pluginName;
    @Parameter(defaultValue="${plugin.version.description}")
    protected String pluginVersionDescription;
    @Parameter
    protected String snapshotPluginVersionOverride;
    @Parameter(defaultValue="true")
    protected boolean failOnVersionOverrideToDifferentRelease = true;
    @Parameter(defaultValue="${project.build.directory}/${project.build.finalName}")
    protected File webappDirectory;
    @Parameter(defaultValue="${basedir}/src/main/webapp")
    protected File warSourceDirectory;
    @Parameter
    private Resource[] webResources;
    @Parameter(defaultValue="${project.build.filters}")
    private List<String> filters;
    @Parameter(defaultValue="${maven.war.containerConfigXML}")
    private File containerConfigXML;
    @Parameter(defaultValue="${project.build.directory}/war/work")
    private File workDirectory;
    @Component
    protected ArchiverManager archiverManager;
    private static final String WEB_INF = "WEB-INF";
    private static final String META_INF = "META-INF";
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/**"};
    @Parameter(alias="includes", defaultValue="**")
    private String warSourceIncludes;
    @Parameter(alias="excludes")
    private String warSourceExcludes;
    @Parameter(defaultValue="**")
    private String dependentWarIncludes;
    @Parameter
    private String dependentWarExcludes;
    @Parameter
    protected String maskClasses;
    @Parameter
    protected String globalMaskClasses;
    @Parameter
    protected boolean pluginFirstClassLoader = false;
    ScopeArtifactFilter scopeFilter = new ScopeArtifactFilter("runtime");
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final Logger LOGGER = Logger.getLogger(AbstractHpiMojo.class.getName());

    public File getClassesDirectory() {
        return this.classesDirectory;
    }

    public void setClassesDirectory(File classesDirectory) {
        this.classesDirectory = classesDirectory;
    }

    public File getWebappDirectory() {
        return this.webappDirectory;
    }

    public void setWebappDirectory(File webappDirectory) {
        this.webappDirectory = webappDirectory;
    }

    public void setWarSourceDirectory(File warSourceDirectory) {
        this.warSourceDirectory = warSourceDirectory;
    }

    public File getContainerConfigXML() {
        return this.containerConfigXML;
    }

    public void setContainerConfigXML(File containerConfigXML) {
        this.containerConfigXML = containerConfigXML;
    }

    protected String[] getExcludes() {
        ArrayList<String> excludeList = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)this.warSourceExcludes)) {
            excludeList.addAll(Arrays.asList(StringUtils.split((String)this.warSourceExcludes, (String)",")));
        }
        if (this.containerConfigXML != null && StringUtils.isNotEmpty((String)this.containerConfigXML.getName())) {
            excludeList.add("**/META-INF/" + this.containerConfigXML.getName());
        }
        return excludeList.toArray(EMPTY_STRING_ARRAY);
    }

    protected String[] getIncludes() {
        return StringUtils.split((String)Objects.toString(this.warSourceIncludes), (String)",");
    }

    protected String[] getDependentWarExcludes() {
        String[] excludes = StringUtils.isNotEmpty((String)this.dependentWarExcludes) ? StringUtils.split((String)this.dependentWarExcludes, (String)",") : EMPTY_STRING_ARRAY;
        return excludes;
    }

    protected String[] getDependentWarIncludes() {
        return StringUtils.split((String)Objects.toString(this.dependentWarIncludes), (String)",");
    }

    public void buildExplodedWebapp(File webappDirectory, File jarFile) throws MojoExecutionException {
        this.getLog().info((CharSequence)"Exploding webapp...");
        webappDirectory.mkdirs();
        File webinfDir = new File(webappDirectory, WEB_INF);
        webinfDir.mkdirs();
        File metainfDir = new File(webappDirectory, META_INF);
        metainfDir.mkdirs();
        try {
            List<Resource> webResources;
            List<Resource> list = webResources = this.webResources != null ? Arrays.asList(this.webResources) : null;
            if (webResources != null && webResources.size() > 0) {
                Properties filterProperties = this.getBuildFilterProperties();
                for (Resource resource : webResources) {
                    this.copyResources(resource, webappDirectory, filterProperties);
                }
            }
            this.copyResources(this.warSourceDirectory, webappDirectory);
            if (this.containerConfigXML != null && StringUtils.isNotEmpty((String)this.containerConfigXML.getName())) {
                metainfDir = new File(webappDirectory, META_INF);
                String xmlFileName = this.containerConfigXML.getName();
                AbstractHpiMojo.copyFileIfModified(this.containerConfigXML, new File(metainfDir, xmlFileName));
            }
            this.buildWebapp(this.project, webappDirectory);
            AbstractHpiMojo.copyFileIfModified(jarFile, new File(this.getWebappDirectory(), "WEB-INF/lib/" + jarFile.getName()));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not explode webapp...", (Exception)e);
        }
    }

    private Properties getBuildFilterProperties() throws MojoExecutionException {
        Properties filterProperties = new Properties(System.getProperties());
        filterProperties.putAll((Map<?, ?>)this.project.getProperties());
        for (String filter : this.filters) {
            try {
                Properties properties = PropertyUtils.loadPropertyFile(new File(filter), true, true);
                filterProperties.putAll((Map<?, ?>)properties);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error loading property file '" + filter + "'", (Exception)e);
            }
        }
        return filterProperties;
    }

    public void copyResources(Resource resource, File webappDirectory, Properties filterProperties) throws IOException {
        if (!resource.getDirectory().equals(webappDirectory.getPath())) {
            this.getLog().info((CharSequence)("Copy webapp webResources to " + webappDirectory.getAbsolutePath()));
            if (webappDirectory.exists()) {
                String[] fileNames;
                for (String fileName : fileNames = this.getWarFiles(resource)) {
                    File targetDirectory = webappDirectory;
                    if (StringUtils.isNotBlank((String)resource.getTargetPath())) {
                        targetDirectory = new File(webappDirectory, resource.getTargetPath());
                    }
                    if (resource.isFiltering()) {
                        AbstractHpiMojo.copyFilteredFile(new File(resource.getDirectory(), fileName), new File(targetDirectory, fileName), null, this.getFilterWrappers(), filterProperties);
                        continue;
                    }
                    AbstractHpiMojo.copyFileIfModified(new File(resource.getDirectory(), fileName), new File(targetDirectory, fileName));
                }
            }
        }
    }

    public void copyResources(File sourceDirectory, File webappDirectory) throws IOException {
        if (!sourceDirectory.equals(webappDirectory)) {
            this.getLog().info((CharSequence)("Copy webapp webResources to " + webappDirectory.getAbsolutePath()));
            if (this.warSourceDirectory.exists()) {
                String[] fileNames;
                for (String fileName : fileNames = this.getWarFiles(sourceDirectory)) {
                    AbstractHpiMojo.copyFileIfModified(new File(sourceDirectory, fileName), new File(webappDirectory, fileName));
                }
            }
        }
    }

    public Set<MavenArtifact> getProjectArtfacts() {
        return this.wrap(Artifacts.of(this.project));
    }

    public Set<MavenArtifact> getDirectDependencyArtfacts() {
        return this.wrap(Artifacts.ofDirectDependencies(this.project));
    }

    protected Set<MavenArtifact> wrap(Iterable<Artifact> artifacts) {
        TreeSet<MavenArtifact> r = new TreeSet<MavenArtifact>();
        for (Artifact a : artifacts) {
            r.add(this.wrap(a));
        }
        return r;
    }

    public void buildWebapp(MavenProject project, File webappDirectory) throws MojoExecutionException, IOException {
        this.getLog().info((CharSequence)("Assembling webapp " + project.getArtifactId() + " in " + webappDirectory));
        File libDirectory = new File(webappDirectory, "WEB-INF/lib");
        File tldDirectory = new File(webappDirectory, "WEB-INF/tld");
        Set<MavenArtifact> artifacts = this.getProjectArtfacts();
        Set<MavenArtifact> dependencyArtifacts = this.getDirectDependencyArtfacts();
        List<String> duplicates = this.findDuplicates(artifacts);
        ArrayList<File> dependentWarDirectories = new ArrayList<File>();
        HashSet<String> jenkinsPlugins = new HashSet<String>();
        HashSet<String> excludedArtifacts = new HashSet<String>();
        for (MavenArtifact artifact : Sets.union(artifacts, dependencyArtifacts)) {
            if (artifact.isPluginBestEffort(this.getLog())) {
                jenkinsPlugins.add(artifact.getId());
            }
            if (!artifact.hasScope("test", "provided")) continue;
            excludedArtifacts.add(artifact.getId());
        }
        block1: for (MavenArtifact artifact : artifacts) {
            this.getLog().debug((CharSequence)("Considering artifact trail " + artifact.getDependencyTrail()));
            if (jenkinsPlugins.contains(artifact.getId()) || artifact.getDependencyTrail().size() >= 1 && (jenkinsPlugins.contains(artifact.getDependencyTrail().get(1)) || excludedArtifacts.contains(artifact.getDependencyTrail().get(1)))) continue;
            for (String trail : artifact.getDependencyTrail()) {
                if (!trail.contains(":hudson-core:") && !trail.contains(":jenkins-core:")) continue;
                continue block1;
            }
            String targetFileName = artifact.getDefaultFinalName();
            this.getLog().debug((CharSequence)("Processing: " + targetFileName));
            if (duplicates.contains(targetFileName)) {
                this.getLog().debug((CharSequence)("Duplicate found: " + targetFileName));
                targetFileName = artifact.getGroupId() + "-" + targetFileName;
                this.getLog().debug((CharSequence)("Renamed to: " + targetFileName));
            }
            ScopeArtifactFilter filter = new ScopeArtifactFilter("runtime");
            if (artifact.isOptional() || !filter.include(artifact.artifact)) continue;
            if (artifact.getDependencyTrail().size() > 2) {
                this.getLog().warn((CharSequence)("Bundling transitive dependency " + targetFileName + " (via " + artifact.getDependencyTrail().get(1).replaceAll("[^:]+:([^:]+):.+", "$1") + ")"));
            } else {
                this.getLog().info((CharSequence)("Bundling direct dependency " + targetFileName));
            }
            String type = artifact.getType();
            if ("tld".equals(type)) {
                AbstractHpiMojo.copyFileIfModified(artifact.getFile(), new File(tldDirectory, targetFileName));
                continue;
            }
            if ("jar".equals(type) || "ejb".equals(type) || "ejb-client".equals(type)) {
                AbstractHpiMojo.copyFileIfModified(artifact.getFile(), new File(libDirectory, targetFileName));
                continue;
            }
            if ("par".equals(type)) {
                targetFileName = targetFileName.substring(0, targetFileName.lastIndexOf(46)) + ".jar";
                this.getLog().debug((CharSequence)("Copying " + artifact.getFile() + " to " + new File(libDirectory, targetFileName)));
                AbstractHpiMojo.copyFileIfModified(artifact.getFile(), new File(libDirectory, targetFileName));
                continue;
            }
            if ("war".equals(type)) {
                dependentWarDirectories.add(this.unpackWarToTempDirectory(artifact));
                continue;
            }
            this.getLog().debug((CharSequence)("Skipping artifact of type " + type + " for WEB-INF/lib"));
        }
        if (dependentWarDirectories.size() > 0) {
            this.getLog().info((CharSequence)("Overlaying " + dependentWarDirectories.size() + " war(s)."));
            for (File dependentWarDirectory : dependentWarDirectories) {
                this.copyDependentWarContents(dependentWarDirectory, webappDirectory);
            }
        }
    }

    private List<String> findDuplicates(Set<MavenArtifact> artifacts) {
        ArrayList<String> duplicates = new ArrayList<String>();
        ArrayList<String> identifiers = new ArrayList<String>();
        for (MavenArtifact artifact : artifacts) {
            String candidate = artifact.getDefaultFinalName();
            if (identifiers.contains(candidate)) {
                duplicates.add(candidate);
                continue;
            }
            identifiers.add(candidate);
        }
        return duplicates;
    }

    private File unpackWarToTempDirectory(MavenArtifact artifact) throws MojoExecutionException {
        String name = artifact.getFile().getName();
        File tempLocation = new File(this.workDirectory, name.substring(0, name.length() - 4));
        boolean process = false;
        if (!tempLocation.exists()) {
            tempLocation.mkdirs();
            process = true;
        } else if (artifact.getFile().lastModified() > tempLocation.lastModified()) {
            process = true;
        }
        if (process) {
            File file = artifact.getFile();
            try {
                this.unpack(file, tempLocation);
            }
            catch (NoSuchArchiverException e) {
                this.getLog().info((CharSequence)("Skip unpacking dependency file with unknown extension: " + file.getPath()));
            }
        }
        return tempLocation;
    }

    private void unpack(File file, File location) throws MojoExecutionException, NoSuchArchiverException {
        String archiveExt = FileUtils.getExtension((String)file.getAbsolutePath()).toLowerCase();
        try {
            UnArchiver unArchiver = this.archiverManager.getUnArchiver(archiveExt);
            unArchiver.setSourceFile(file);
            unArchiver.setDestDirectory(location);
            unArchiver.extract();
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Error unpacking file: " + file + "to: " + location, (Exception)((Object)e));
        }
    }

    private void copyDependentWarContents(File srcDir, File targetDir) throws MojoExecutionException {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(srcDir);
        scanner.setExcludes(this.getDependentWarExcludes());
        scanner.addDefaultExcludes();
        scanner.setIncludes(this.getDependentWarIncludes());
        scanner.scan();
        for (String dir : scanner.getIncludedDirectories()) {
            new File(targetDir, dir).mkdirs();
        }
        for (String file : scanner.getIncludedFiles()) {
            File targetFile = new File(targetDir, file);
            if (targetFile.exists()) continue;
            try {
                targetFile.getParentFile().mkdirs();
                AbstractHpiMojo.copyFileIfModified(new File(srcDir, file), targetFile);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error copying file '" + file + "' to '" + targetFile + "'", (Exception)e);
            }
        }
    }

    private String[] getWarFiles(File sourceDir) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(sourceDir);
        scanner.setExcludes(this.getExcludes());
        scanner.addDefaultExcludes();
        scanner.setIncludes(this.getIncludes());
        scanner.scan();
        return scanner.getIncludedFiles();
    }

    private String[] getWarFiles(Resource resource) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(resource.getDirectory());
        if (resource.getIncludes() != null && !resource.getIncludes().isEmpty()) {
            scanner.setIncludes(resource.getIncludes().toArray(EMPTY_STRING_ARRAY));
        } else {
            scanner.setIncludes(DEFAULT_INCLUDES);
        }
        if (resource.getExcludes() != null && !resource.getExcludes().isEmpty()) {
            scanner.setExcludes(resource.getExcludes().toArray(EMPTY_STRING_ARRAY));
        }
        scanner.addDefaultExcludes();
        scanner.scan();
        return scanner.getIncludedFiles();
    }

    private static void copyFileToDirectoryIfModified(File source, File destinationDirectory) throws IOException {
        if (destinationDirectory.exists() && !destinationDirectory.isDirectory()) {
            throw new IllegalArgumentException("Destination is not a directory");
        }
        AbstractHpiMojo.copyFileIfModified(source, new File(destinationDirectory, source.getName()));
    }

    private FilterWrapper[] getFilterWrappers() {
        return new FilterWrapper[]{new FilterWrapper(){

            @Override
            public Reader getReader(Reader fileReader, Properties filterProperties) {
                return new InterpolationFilterReader(fileReader, (Map)filterProperties, "${", "}");
            }
        }, new FilterWrapper(){

            @Override
            public Reader getReader(Reader fileReader, Properties filterProperties) {
                return new InterpolationFilterReader(fileReader, (Map)filterProperties, "@", "@");
            }
        }};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFilteredFile(File from, File to, String encoding, FilterWrapper[] wrappers, Properties filterProperties) throws IOException {
        BufferedReader fileReader = null;
        OutputStreamWriter fileWriter = null;
        try {
            to.getParentFile().mkdirs();
            if (encoding == null || encoding.length() < 1) {
                fileReader = new BufferedReader(new FileReader(from));
                fileWriter = new FileWriter(to);
            } else {
                FileInputStream instream = new FileInputStream(from);
                FileOutputStream outstream = new FileOutputStream(to);
                fileReader = new BufferedReader(new InputStreamReader((InputStream)instream, encoding));
                fileWriter = new OutputStreamWriter((OutputStream)outstream, encoding);
            }
            Reader reader = fileReader;
            for (FilterWrapper wrapper : wrappers) {
                reader = wrapper.getReader(reader, filterProperties);
            }
            IOUtil.copy((Reader)reader, (Writer)fileWriter);
        }
        catch (Throwable throwable) {
            IOUtil.close(fileReader);
            IOUtil.close(fileWriter);
            throw throwable;
        }
        IOUtil.close((Reader)fileReader);
        IOUtil.close((Writer)fileWriter);
    }

    private static void copyFileIfModified(File source, File destination) throws IOException {
        if (destination.lastModified() < source.lastModified()) {
            FileUtils.copyFile((File)source, (File)destination);
        }
    }

    private static void copyDirectoryStructureIfModified(File sourceDirectory, File destinationDirectory) throws IOException {
        if (!sourceDirectory.exists()) {
            throw new IOException("Source directory doesn't exists (" + sourceDirectory.getAbsolutePath() + ").");
        }
        String sourcePath = sourceDirectory.getAbsolutePath();
        for (File file : sourceDirectory.listFiles()) {
            String dest = file.getAbsolutePath();
            dest = dest.substring(sourcePath.length() + 1);
            File destination = new File(destinationDirectory, dest);
            if (file.isFile()) {
                destination = destination.getParentFile();
                AbstractHpiMojo.copyFileToDirectoryIfModified(file, destination);
                continue;
            }
            if (file.isDirectory()) {
                if (!destination.exists() && !destination.mkdirs()) {
                    throw new IOException("Could not create destination directory '" + destination.getAbsolutePath() + "'.");
                }
                AbstractHpiMojo.copyDirectoryStructureIfModified(file, destination);
                continue;
            }
            throw new IOException("Unknown file type: " + file.getAbsolutePath());
        }
    }

    public String getGitHeadSha1() {
        File git = new File(this.project.getBasedir(), ".git");
        if (!git.exists() && !(git = new File(this.project.getBasedir(), "../.git")).exists()) {
            return null;
        }
        try {
            Process p = new ProcessBuilder("git", "-C", git.getAbsolutePath(), "rev-parse", "HEAD").redirectErrorStream(true).start();
            p.getOutputStream().close();
            String v = IOUtils.toString((InputStream)p.getInputStream()).trim();
            if (p.waitFor() != 0) {
                return null;
            }
            return v.trim().substring(0, 8);
        }
        catch (IOException | InterruptedException e) {
            LOGGER.log(Level.FINE, "Failed to run git rev-parse HEAD", e);
            return null;
        }
    }

    protected Boolean isSupportDynamicLoading() throws IOException {
        URLClassLoader cl = new URLClassLoader(new URL[]{new File(this.project.getBuild().getOutputDirectory()).toURI().toURL()}, ((Object)((Object)this)).getClass().getClassLoader());
        EnumSet<YesNoMaybe> e = EnumSet.noneOf(YesNoMaybe.class);
        for (IndexItem i : Index.load(Extension.class, Object.class, (ClassLoader)cl)) {
            e.add(((Extension)i.annotation()).dynamicLoadable());
        }
        if (e.contains((Object)YesNoMaybe.NO)) {
            return false;
        }
        if (e.contains((Object)YesNoMaybe.MAYBE)) {
            return null;
        }
        return true;
    }

    private static interface FilterWrapper {
        public Reader getReader(Reader var1, Properties var2);
    }
}

