package org.jenkins.tools.test.model.hook;

import edu.umd.cs.findbugs.annotations.NonNull;
import org.apache.maven.model.Model;
import org.jenkins.tools.test.model.PluginCompatTesterConfig;
import org.jenkins.tools.test.model.UpdateSite;

public abstract class StageContext {

    @NonNull
    private final Stage stage;

    @NonNull
    private final UpdateSite.Plugin plugin;

    @NonNull
    private final Model model;

    @NonNull
    private final String coreVersion;

    @NonNull
    private final PluginCompatTesterConfig config;

    public StageContext(
            @NonNull Stage stage,
            @NonNull UpdateSite.Plugin plugin,
            @NonNull Model model,
            @NonNull String coreVersion,
            @NonNull PluginCompatTesterConfig config) {
        this.stage = stage;
        this.plugin = plugin;
        this.model = model;
        this.coreVersion = coreVersion;
        this.config = config;
    }

    @NonNull
    public Stage getStage() {
        return stage;
    }

    @NonNull
    public UpdateSite.Plugin getPlugin() {
        return plugin;
    }

    @NonNull
    public Model getModel() {
        return model;
    }

    @NonNull
    public String getCoreVersion() {
        return coreVersion;
    }

    @NonNull
    public PluginCompatTesterConfig getConfig() {
        return config;
    }
}
