/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.test.acceptance.docker.fixtures;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermission;
import java.util.EnumSet;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.SystemUtils;
import org.jenkinsci.test.acceptance.docker.DockerContainer;
import org.jenkinsci.test.acceptance.docker.DockerFixture;
import org.jenkinsci.utils.process.CommandBuilder;
import org.jenkinsci.utils.process.ProcessInputStream;

@DockerFixture(id="sshd", ports={22})
public class SshdContainer
extends DockerContainer {
    private File privateKey;
    private File privateKeyEnc;

    public File getPrivateKey() {
        if (this.privateKey == null) {
            try {
                this.privateKey = File.createTempFile("ssh", "key");
                this.privateKey.deleteOnExit();
                FileUtils.copyURLToFile((URL)this.resource((String)"unsafe").url, (File)this.privateKey);
                if (SystemUtils.IS_OS_UNIX) {
                    Files.setPosixFilePermissions(this.privateKey.toPath(), EnumSet.of(PosixFilePermission.OWNER_READ));
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Not able to get the plaintext SSH key file. Missing file, wrong file permissions?!");
            }
        }
        return this.privateKey;
    }

    public File getEncryptedPrivateKey() {
        if (this.privateKeyEnc == null) {
            try {
                this.privateKeyEnc = File.createTempFile("ssh_enc", "key");
                this.privateKeyEnc.deleteOnExit();
                FileUtils.copyURLToFile((URL)this.resource((String)"unsafe_enc_key").url, (File)this.privateKeyEnc);
                if (SystemUtils.IS_OS_UNIX) {
                    Files.setPosixFilePermissions(this.privateKeyEnc.toPath(), EnumSet.of(PosixFilePermission.OWNER_READ));
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Not able to get the encrypted SSH key file. Missing file, wrong file permissions?!");
            }
        }
        return this.privateKeyEnc;
    }

    public String getPrivateKeyString() {
        try {
            return new String(Files.readAllBytes(this.getPrivateKey().toPath()));
        }
        catch (IOException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public CommandBuilder ssh() {
        return new CommandBuilder(new String[]{"ssh"}).add(new Object[]{"-p", this.port(22), "-o", "StrictHostKeyChecking=no", "-i", this.getPrivateKey(), "test@" + this.ipBound(22)});
    }

    public void sshWithPublicKey(CommandBuilder cmd) throws IOException, InterruptedException {
        if (this.ssh().add(cmd).system() != 0) {
            throw new AssertionError((Object)("ssh failed: " + cmd));
        }
    }

    public ProcessInputStream popen(CommandBuilder cmd) throws IOException, InterruptedException {
        return this.ssh().add(cmd).popen();
    }
}

