/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.test.acceptance.docker;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Formatter;

class SHA1Sum {
    private byte[] sha1 = null;
    private String sha1String = null;
    private File inFile = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    SHA1Sum(File inFile) {
        if (!inFile.isFile()) throw new RuntimeException("You are trying to make a sha1sum a directory!");
        if (!inFile.canRead()) throw new RuntimeException("You are trying to make a sha1sum of a read protected file!");
        this.inFile = inFile;
        try {
            this.sha1 = this.createSha1(this.inFile);
        }
        catch (IOException | NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        this.sha1String = this.convertByteToString(this.sha1);
    }

    public String getSha1String() {
        return this.sha1String;
    }

    public byte[] getSha1ByteArray() {
        return this.sha1;
    }

    private String convertByteToString(byte[] inByte) {
        Formatter formatter = new Formatter();
        for (byte b : inByte) {
            formatter.format("%02x", b);
        }
        return formatter.toString();
    }

    private byte[] createSha1(File file) throws NoSuchAlgorithmException, IOException {
        int n = 0;
        byte[] buffer = new byte[8192];
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        try (FileInputStream fis = new FileInputStream(file);){
            while (n != -1) {
                n = ((InputStream)fis).read(buffer);
                if (n <= 0) continue;
                digest.update(buffer, 0, n);
            }
            byte[] byArray = digest.digest();
            return byArray;
        }
    }
}

