/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.test.acceptance.docker;

import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.io.IOUtils;

public class Resource {
    public final URL url;

    public Resource(URL url) {
        this.url = url;
    }

    public String getName() {
        String s = this.url.toExternalForm();
        return s.substring(s.lastIndexOf(47) + 1);
    }

    public InputStream asInputStream() {
        try {
            return this.url.openStream();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public Reader asReader() {
        try {
            return new InputStreamReader(this.url.openStream());
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public String asText() {
        try {
            return IOUtils.toString((InputStream)this.url.openStream());
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public byte[] asByteArray() throws IOException {
        try (InputStream is = this.asInputStream();){
            byte[] byArray = IOUtils.toByteArray((InputStream)is);
            return byArray;
        }
    }

    public File asFile() {
        try {
            return new File(this.url.toURI());
        }
        catch (URISyntaxException e) {
            throw new IOError(e);
        }
    }
}

