/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.test.acceptance.docker;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import org.apache.commons.io.FileUtils;
import org.jenkinsci.test.acceptance.docker.Docker;
import org.jenkinsci.test.acceptance.docker.DockerContainer;
import org.jenkinsci.test.acceptance.docker.DockerImage;
import org.junit.internal.AssumptionViolatedException;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public final class DockerRule<T extends DockerContainer>
implements TestRule {
    private final Class<T> type;
    private boolean localOnly;
    private T container;
    private File buildlog;
    private File runlog;

    public DockerRule(Class<T> type) {
        this.type = type;
    }

    public DockerRule<T> localOnly() {
        this.localOnly = true;
        return this;
    }

    public T get() throws IOException, InterruptedException {
        if (this.container == null) {
            String host;
            Docker docker = new Docker();
            if (!docker.isAvailable()) {
                throw new AssumptionViolatedException("Docker is needed for the test");
            }
            if (this.localOnly && !InetAddress.getByName(host = DockerImage.getDockerHost()).isLoopbackAddress()) {
                throw new AssumptionViolatedException("Docker is needed locally for the test but is running on " + host);
            }
            this.buildlog = File.createTempFile("docker-" + this.type.getSimpleName() + "-build", ".log");
            DockerImage image = docker.build(this.type, this.buildlog);
            this.buildlog.delete();
            this.buildlog = null;
            this.runlog = File.createTempFile("docker-" + this.type.getSimpleName() + "-run", ".log");
            this.container = image.start(this.type).withLog(this.runlog).start();
        }
        return this.container;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    base.evaluate();
                }
                catch (AssumptionViolatedException e) {
                    throw e;
                }
                catch (Throwable t) {
                    this.dump(DockerRule.this.buildlog);
                    this.dump(DockerRule.this.runlog);
                    throw t;
                }
                finally {
                    if (DockerRule.this.buildlog != null) {
                        DockerRule.this.buildlog.delete();
                        DockerRule.this.buildlog = null;
                    }
                    if (DockerRule.this.runlog != null) {
                        DockerRule.this.runlog.delete();
                        DockerRule.this.runlog = null;
                    }
                    if (DockerRule.this.container != null) {
                        DockerRule.this.container.close();
                        DockerRule.this.container = null;
                    }
                }
            }

            private void dump(File log) throws IOException {
                if (log != null) {
                    System.out.println("---%<--- " + log.getName());
                    FileUtils.copyFile((File)log, (OutputStream)System.out);
                    System.out.println("--->%---");
                }
            }
        };
    }
}

