/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.test.acceptance.docker;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URI;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.SystemUtils;
import org.jenkinsci.test.acceptance.docker.Docker;
import org.jenkinsci.test.acceptance.docker.DockerContainer;
import org.jenkinsci.test.acceptance.docker.DockerFixture;
import org.jenkinsci.utils.process.CommandBuilder;

public class DockerImage {
    public static final String DEFAULT_DOCKER_HOST = "127.0.0.1";
    public final String tag;
    static DockerHostResolver dockerHostResolver = new DockerHostResolver();

    public DockerImage(String tag) {
        this.tag = tag;
    }

    public <T extends DockerContainer> Starter<T> start(Class<T> type) {
        return new Starter<T>(type, this);
    }

    @Deprecated
    public <T extends DockerContainer> T start(Class<T> type, CommandBuilder options, CommandBuilder cmd, int portOffset) throws InterruptedException, IOException {
        DockerFixture f = type.getAnnotation(DockerFixture.class);
        String addr = f.bindIp();
        if (!"".equals(f.bindIp())) {
            if (InetAddress.getByName(DockerImage.getDockerHost()).isLoopbackAddress()) {
                return this.start(type).withPortOffset(portOffset).withIpAddress(f.bindIp()).withOptions(options).withArgs(cmd).start();
            }
            throw new AssertionError((Object)("Test would fail as docker requires local networks on a remote machine - Hint use `@WithDocker(localOnly=true)\u00b4 or do not specify a bindIp in " + type.getName()));
        }
        return this.start(type).withPortOffset(portOffset).withOptions(options).withArgs(cmd).start();
    }

    @Deprecated
    public <T extends DockerContainer> T start(Class<T> type, CommandBuilder options, CommandBuilder cmd) throws InterruptedException, IOException {
        return this.start(type).withOptions(options).withArgs(cmd).start();
    }

    @Deprecated
    public <T extends DockerContainer> T start(Class<T> type, int[] ports, CommandBuilder options, CommandBuilder cmd) throws InterruptedException, IOException {
        return this.start(type).withPorts(ports).withOptions(options).withArgs(cmd).start();
    }

    @Deprecated
    public <T extends DockerContainer> T start(Class<T> type, int[] ports, int localPortOffset, String ipAddress, CommandBuilder options, CommandBuilder cmd) throws InterruptedException, IOException {
        return this.start(type).withPorts(ports).withPortOffset(localPortOffset).withIpAddress(ipAddress).withOptions(options).withArgs(cmd).start();
    }

    private <T extends DockerContainer> T start(Starter starter, Class<T> type) throws InterruptedException, IOException {
        CommandBuilder docker = Docker.cmd("run");
        docker.add("-d");
        for (int p : starter.ports) {
            docker.add(new String[]{"-p", starter.getPortMapping(p)});
        }
        docker.add(starter.options);
        docker.add(this.tag);
        docker.add(starter.args);
        File logfile = starter.log;
        System.out.printf("Launching Docker container `%s`: logfile will be at %s\n", docker.toString(), logfile);
        Process p = docker.build().redirectInput(new File(SystemUtils.IS_OS_WINDOWS ? "NUL" : "/dev/null")).redirectErrorStream(true).start();
        String cid = this.waitForCid(docker, p);
        Process logProcess = Docker.cmd("logs").add("-f").add(cid).build().redirectInput(new File(SystemUtils.IS_OS_WINDOWS ? "NUL" : "/dev/null")).redirectErrorStream(true).redirectOutput(logfile).start();
        try {
            DockerContainer t = (DockerContainer)type.newInstance();
            t.init(cid, logProcess, logfile);
            return (T)t;
        }
        catch (ReflectiveOperationException e) {
            throw new Error(e);
        }
    }

    private String waitForCid(CommandBuilder docker, Process p) throws InterruptedException, IOException {
        String output = IOUtils.toString((InputStream)p.getInputStream());
        if (p.waitFor() != 0) {
            throw new IOException("docker died unexpectedly with return code " + p.exitValue() + " : " + docker + "\n" + output);
        }
        if (output != null && output.length() != 0) {
            return output.trim();
        }
        throw new IOException("docker didn't output a container id or have a non-zero exit status. Huh?: " + docker);
    }

    public static String getDockerHost() {
        String dockerHostEnvironmentVariable = dockerHostResolver.getDockerHostEnvironmentVariable();
        return dockerHostEnvironmentVariable != null ? DockerImage.getIp(dockerHostEnvironmentVariable) : DEFAULT_DOCKER_HOST;
    }

    private static String getIp(String uri) {
        URI dockerHost = URI.create(uri);
        String host = dockerHost.getHost();
        return host != null ? host : DEFAULT_DOCKER_HOST;
    }

    public String toString() {
        return "DockerImage: " + this.tag;
    }

    public static final class Starter<T extends DockerContainer> {
        private final DockerImage image;
        private final Class<T> type;
        private CommandBuilder options;
        private CommandBuilder args;
        private String ipAddress = DockerImage.getDockerHost();
        private Integer portOffset;
        private int[] ports;
        private File log;

        public Starter(Class<T> type, DockerImage image) {
            this.type = type;
            this.image = image;
            DockerFixture fixtureAnnotation = type.getAnnotation(DockerFixture.class);
            this.ports = fixtureAnnotation.ports();
            if (fixtureAnnotation.matchHostPorts()) {
                this.portOffset = 0;
            }
        }

        @Nonnull
        public Starter<T> withPorts(int ... ports) {
            this.ports = ports;
            return this;
        }

        @Nonnull
        public Starter<T> withPortOffset(Integer portOffset) {
            this.portOffset = portOffset;
            return this;
        }

        @Nonnull
        public Starter<T> withIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        @Nonnull
        public Starter<T> withOptions(CommandBuilder options) {
            this.options = options;
            return this;
        }

        @Nonnull
        public Starter<T> withArgs(CommandBuilder args) {
            this.args = args;
            return this;
        }

        @Nonnull
        public Starter<T> withLog(File log) {
            this.log = log;
            return this;
        }

        @Nonnull
        public T start() throws InterruptedException, IOException {
            return (T)this.image.start(this, this.type);
        }

        private String getPortMapping(int port) {
            return this.portOffset == null ? this.ipAddress + "::" + port : this.ipAddress + ":" + (this.portOffset + port) + ":" + port;
        }
    }

    static class DockerHostResolver {
        DockerHostResolver() {
        }

        public String getDockerHostEnvironmentVariable() {
            return System.getenv("DOCKER_HOST");
        }
    }
}

