/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.test.acceptance.docker;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.jenkinsci.test.acceptance.docker.Docker;
import org.jenkinsci.test.acceptance.docker.Resource;
import org.jenkinsci.utils.process.ProcessUtils;

public class DockerContainer
implements Closeable {
    private String cid;
    private Process p;
    private File logfile;
    private Thread shutdownHook;

    void init(String cid, Process p, File logfile) {
        this.cid = cid;
        this.p = p;
        this.logfile = logfile;
        this.shutdownHook = new Thread(){

            @Override
            public void run() {
                DockerContainer.this.shutdownHook = null;
                DockerContainer.this.close();
            }
        };
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        this.assertRunning();
    }

    public void assertRunning() {
        try {
            JsonNode state = this.inspect().get("State");
            if (!"running".equals(state.get("Status").asText())) {
                throw new Error("The container is not running: " + state.toString());
            }
        }
        catch (IOException e) {
            throw new Error("The container is not running", e);
        }
    }

    public Resource resource(String relativePath) {
        for (Class<?> c = this.getClass(); c != null; c = c.getSuperclass()) {
            URL res = c.getResource(c.getSimpleName() + "/" + relativePath);
            if (res == null) continue;
            return new Resource(res);
        }
        throw new IllegalArgumentException("No such resource " + relativePath + " in " + this.getClass());
    }

    public String getCid() {
        return this.cid;
    }

    public File getLogfile() {
        return this.logfile;
    }

    public int getPid() {
        return ProcessUtils.getPid((Process)this.p);
    }

    public String ipBound(int n) {
        this.assertRunning();
        try {
            if (this.sharingHostDockerService()) {
                return this.getIpAddress();
            }
            String out = Docker.cmd("port").add(new Object[]{this.cid, n}).popen().verifyOrDieWith("docker port command failed").trim();
            if (out.isEmpty()) {
                throw new IllegalStateException(String.format("Port %d is not mapped for container %s", n, this.cid));
            }
            return out.split(":")[0];
        }
        catch (IOException | InterruptedException e) {
            throw new AssertionError("Failed to figure out port map " + n, e);
        }
    }

    public int port(int n) {
        this.assertRunning();
        try {
            if (this.sharingHostDockerService()) {
                return n;
            }
            String out = Docker.cmd("port").add(new Object[]{this.cid, n}).popen().verifyOrDieWith("docker port command failed").trim();
            if (out.isEmpty()) {
                throw new IllegalStateException(String.format("Port %d is not mapped for container %s", n, this.cid));
            }
            return Integer.parseInt(out.split(":")[1]);
        }
        catch (IOException | InterruptedException e) {
            throw new AssertionError("Failed to figure out port map " + n, e);
        }
    }

    @Override
    public void close() {
        try {
            this.p.destroy();
            int killStatus = Docker.cmd("kill").add(this.cid).build().inheritIO().start().waitFor();
            Docker.cmd("rm").add(this.cid).popen().verifyOrDieWith("Failed to rm " + this.cid + ". kill completed with " + killStatus);
            if (this.shutdownHook != null) {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
        }
        catch (IOException | InterruptedException e) {
            throw new AssertionError("Failed to close down docker container " + this.cid, e);
        }
    }

    public boolean cp(String from, String toPath) {
        this.assertRunning();
        File srcFile = new File(from);
        String fileName = srcFile.getName();
        File destFile = new File(toPath, fileName);
        if (destFile.exists()) {
            destFile.delete();
        }
        try {
            Docker.cmd("cp").add(this.cid + ":" + from).add(new File(toPath)).popen().verifyOrDieWith(String.format("Failed to copy %s to %s", from, toPath));
        }
        catch (IOException | InterruptedException e) {
            return false;
        }
        this.assertRunning();
        return destFile.exists();
    }

    public JsonNode inspect() throws IOException {
        return new ObjectMapper().readTree(Docker.cmd("inspect").add(this.cid).popen().withErrorCheck()).get(0);
    }

    public String getIpAddress() throws IOException {
        return this.inspect().get("NetworkSettings").get("IPAddress").asText();
    }

    public String toString() {
        return "Docker container " + this.cid;
    }

    public boolean sharingHostDockerService() {
        return Boolean.valueOf(System.getenv("SHARED_DOCKER_SERVICE"));
    }
}

