/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.test.acceptance.docker;

import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.annotation.CheckForNull;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.jenkinsci.test.acceptance.docker.DockerContainer;
import org.jenkinsci.test.acceptance.docker.DockerFixture;
import org.jenkinsci.test.acceptance.docker.DockerImage;
import org.jenkinsci.test.acceptance.docker.DynamicDockerContainer;
import org.jenkinsci.test.acceptance.docker.SHA1Sum;
import org.jenkinsci.test.acceptance.docker.Which;
import org.jenkinsci.utils.process.CommandBuilder;
import org.jvnet.hudson.annotation_indexer.Index;

@Singleton
public class Docker {
    @Inject(optional=true)
    @Named(value="docker")
    private static String stringDockerCmd = "docker";
    private static List<String> dockerCmd;
    @Inject(optional=true)
    public ClassLoader classLoader = Thread.currentThread().getContextClassLoader();

    public Docker() {
        dockerCmd = Arrays.asList(stringDockerCmd);
    }

    public static CommandBuilder cmd(String ... cmd) {
        return new CommandBuilder(dockerCmd).add(cmd);
    }

    public boolean isAvailable() {
        try {
            return Docker.cmd("ps").popen().waitFor() == 0;
        }
        catch (IOException | InterruptedException e) {
            return false;
        }
    }

    public boolean isContainerRunning(String container) throws IOException, InterruptedException {
        ProcessBuilder pBuilder = Docker.cmd("ps").add(new String[]{"-q", "--filter", "\"id=" + container + '\"'}).build();
        Process psProcess = pBuilder.start();
        String psOutput = IOUtils.toString((InputStream)psProcess.getInputStream());
        int pExit = psProcess.waitFor();
        if (pExit == 0) {
            return psOutput.contains(container);
        }
        System.err.println("docker ps failed with code: " + pExit + (psOutput != null ? " and output: " + psOutput : " and provided no output"));
        return false;
    }

    private DockerImage build(String image, File dir) throws IOException, InterruptedException {
        return this.build(image, dir, null);
    }

    private DockerImage build(String image, File dir, @CheckForNull File log) throws IOException, InterruptedException {
        String tag = this.getDockerFileHash(dir);
        String fullTag = image + ":" + tag;
        CommandBuilder buildCmd = Docker.cmd("build").add(new String[]{"-t", fullTag});
        buildCmd.add(dir);
        ProcessBuilder processBuilder = buildCmd.build().redirectErrorStream(true);
        if (log != null) {
            processBuilder.redirectOutput(ProcessBuilder.Redirect.appendTo(log));
        } else {
            processBuilder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
        }
        StringBuilder sb = new StringBuilder("Building Docker image `").append(buildCmd.toString()).append("`");
        if (log != null) {
            sb.append(": logfile is at ").append(log);
        }
        System.out.println(sb.toString());
        int exit = processBuilder.start().waitFor();
        if (exit != 0) {
            throw new Error("Failed to build image (" + exit + "): " + tag);
        }
        return new DockerImage(fullTag);
    }

    public DockerImage build(Class<? extends DockerContainer> fixture) throws IOException, InterruptedException {
        return this.build(fixture, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DockerImage build(Class<? extends DockerContainer> fixture, File log) throws IOException, InterruptedException {
        DockerImage dockerImage;
        if (fixture.getSuperclass() != DockerContainer.class && fixture.getSuperclass() != DynamicDockerContainer.class) {
            this.build(fixture.getSuperclass(), log);
        }
        DockerFixture f = fixture.getAnnotation(DockerFixture.class);
        if (f == null) {
            throw new AssertionError((Object)(fixture + " is missing @DockerFixture"));
        }
        File dir = File.createTempFile("Dockerfile", "dir");
        dir.delete();
        dir.mkdirs();
        try {
            this.copyDockerfileDirectory(fixture, f, dir);
            dockerImage = this.build("jenkins/" + f.id(), dir, log);
        }
        catch (Throwable throwable) {
            try {
                FileUtils.deleteDirectory((File)dir);
                throw throwable;
            }
            catch (IOException | InterruptedException e) {
                throw new IOException("Failed to build image: " + fixture, e);
            }
        }
        FileUtils.deleteDirectory((File)dir);
        return dockerImage;
    }

    void copyDockerfileDirectory(Class<? extends DockerContainer> fixture, DockerFixture f, File dir) throws IOException {
        String dockerfilePath = this.resolveDockerfileLocation(fixture, f);
        this.copyDockerfileDirectoryFromClasspath(fixture, dockerfilePath, dir);
    }

    private String resolveDockerfileLocation(Class<? extends DockerContainer> fixture, DockerFixture f) {
        String prefix = this.isSpecificDockerfileLocationSet(f) ? f.dockerfileFolder() : fixture.getName();
        return prefix.replace('.', '/').replace('$', '/');
    }

    private void copyDockerfileDirectoryFromClasspath(Class<? extends DockerContainer> fixture, String dockerfileLocation, File dir) throws IOException {
        File jar = null;
        try {
            jar = Which.jarFile(fixture);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (jar != null && jar.isFile()) {
            dockerfileLocation = dockerfileLocation + "/";
            this.copyDockerfileDirectoryFromPackaged(jar, dockerfileLocation, dir);
        } else {
            this.copyDockerfileDirectoryFromLocal(dockerfileLocation, dir);
        }
        if (DynamicDockerContainer.class.isAssignableFrom(fixture)) {
            try {
                DynamicDockerContainer newInstance = (DynamicDockerContainer)fixture.newInstance();
                newInstance.process(new File(dir, "Dockerfile"));
            }
            catch (IllegalAccessException | InstantiationException ex) {
                throw new IOException("Could not transfrom Dockerfile", ex);
            }
        }
    }

    private boolean isSpecificDockerfileLocationSet(DockerFixture f) {
        return !f.dockerfileFolder().isEmpty();
    }

    private void copyDockerfileDirectoryFromPackaged(File jar, String fixtureLocation, File outputDirectory) throws IOException {
        try (JarFile j = new JarFile(jar);){
            Enumeration<JarEntry> e = j.entries();
            while (e.hasMoreElements()) {
                JarEntry je = e.nextElement();
                if (!je.getName().startsWith(fixtureLocation)) continue;
                File dst = new File(outputDirectory, je.getName().substring(fixtureLocation.length()));
                if (je.isDirectory()) {
                    dst.mkdirs();
                    continue;
                }
                InputStream in = j.getInputStream(je);
                Throwable throwable = null;
                try {
                    FileUtils.copyInputStreamToFile((InputStream)in, (File)dst);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    in.close();
                }
            }
        }
    }

    private void copyDockerfileDirectoryFromLocal(String fixtureLocation, File outputDirectory) throws IOException {
        URL resourceDir = this.classLoader.getResource(fixtureLocation);
        if (resourceDir == null) {
            throw new Error("The fixture directory does not exist: " + fixtureLocation);
        }
        this.copyFile(outputDirectory, resourceDir);
    }

    private void copyFile(File outputDirectory, URL resourceDir) throws IOException {
        File dockerFileDir;
        try {
            dockerFileDir = new File(resourceDir.toURI());
        }
        catch (URISyntaxException e) {
            dockerFileDir = new File(resourceDir.getPath());
        }
        FileUtils.copyDirectory((File)dockerFileDir, (File)outputDirectory);
    }

    private String getDockerFileHash(File dockerFileDir) {
        File dockerFile = new File(dockerFileDir, "Dockerfile");
        SHA1Sum dockerFileHash = new SHA1Sum(dockerFile);
        return dockerFileHash.getSha1String().substring(0, 12);
    }

    public Class<? extends DockerContainer> findFixture(String id) throws IOException {
        for (Class t : Index.list(DockerFixture.class, (ClassLoader)this.classLoader, Class.class)) {
            if (!t.getAnnotation(DockerFixture.class).id().equals(id)) continue;
            return t.asSubclass(DockerContainer.class);
        }
        throw new IllegalArgumentException("No such docker fixture found: " + id);
    }
}

