/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.RubyMotion;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import java.io.OutputStream;
import java.util.Map;

public class RubyMotionCommandLauncher {
    private final AbstractBuild build;
    private final Launcher launcher;
    private final BuildListener listener;

    public RubyMotionCommandLauncher(AbstractBuild build, Launcher launcher, BuildListener listener) {
        this.build = build;
        this.launcher = launcher;
        this.listener = listener;
    }

    public String getProjectWorkspace() {
        return this.build.getWorkspace().getRemote();
    }

    public FilePath getWorkspaceFilePath(String fileName) {
        if (this.build.getWorkspace().isRemote()) {
            return new FilePath(this.build.getWorkspace().getChannel(), this.build.getWorkspace().getRemote() + "/" + fileName);
        }
        return new FilePath(this.build.getWorkspace(), fileName);
    }

    public boolean exec(String command) {
        command = "bash -c \"" + command + "\"";
        try {
            int r = this.launcher.launch().cmdAsSingleString(command).envs((Map)this.build.getEnvironment((TaskListener)this.listener)).stdout((OutputStream)this.listener.getLogger()).pwd(this.getProjectWorkspace()).join();
            return r == 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.listener.getLogger().println("Exception !");
            return false;
        }
    }

    public boolean exec(String command, OutputStream outputStream) {
        command = "bash -c \"" + command + "\"";
        try {
            int r = this.launcher.launch().cmdAsSingleString(command).envs((Map)this.build.getEnvironment((TaskListener)this.listener)).stdout(outputStream).stderr((OutputStream)this.listener.getLogger()).pwd(this.getProjectWorkspace()).join();
            return r == 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.listener.getLogger().println("Exception !");
            return false;
        }
    }

    public void removeFile(String file) {
        FilePath fp = this.getWorkspaceFilePath(file);
        try {
            if (fp.exists()) {
                fp.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void printLog(String string) {
        this.listener.getLogger().println(string);
    }
}

