/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.RubyMotion;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.tasks.Builder;
import java.io.OutputStream;
import org.jenkinsci.plugins.RubyMotion.RubyMotionBuilder;
import org.jenkinsci.plugins.RubyMotion.RubyMotionCommandLauncher;
import org.kohsuke.stapler.DataBoundConstructor;

public class RubyMotionBuilder
extends Builder {
    private final String platform;
    private final String rakeTask;
    private final String outputStyle;
    private final String outputFileName;
    private final boolean useBundler;
    private final boolean installCocoaPods;
    private final boolean needClean;
    private final boolean outputResult;
    private final String deviceName;
    private final String simulatorVersion;
    private transient RubyMotionCommandLauncher cmdLauncher = null;

    @DataBoundConstructor
    public RubyMotionBuilder(String platform, String rakeTask, String outputStyle, String outputFileName, boolean useBundler, boolean installCocoaPods, boolean needClean, boolean outputResult, String deviceName, String simulatorVersion) {
        this.platform = platform;
        this.rakeTask = rakeTask;
        this.outputStyle = outputStyle;
        this.outputFileName = outputFileName;
        this.useBundler = useBundler;
        this.installCocoaPods = installCocoaPods;
        this.needClean = needClean;
        this.outputResult = outputResult;
        this.deviceName = deviceName;
        this.simulatorVersion = simulatorVersion;
    }

    public String getPlatform() {
        return this.platform;
    }

    public String getRakeTask() {
        return this.rakeTask;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public String getOutputStyle() {
        return this.outputStyle;
    }

    public String getSimulatorVersion() {
        return this.simulatorVersion;
    }

    public String getOutputFileName() {
        return this.outputFileName;
    }

    public boolean getUseBundler() {
        return this.useBundler;
    }

    public boolean getInstallCocoaPods() {
        return this.installCocoaPods;
    }

    public boolean getNeedClean() {
        return this.needClean;
    }

    public boolean getOutputResult() {
        return this.outputResult;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        String cmds;
        boolean result;
        this.cmdLauncher = new RubyMotionCommandLauncher(build, launcher, listener);
        this.cmdLauncher.removeFile(this.outputFileName);
        this.cmdLauncher.removeFile(".jenkins-error");
        if (this.useBundler && !(result = this.cmdLauncher.exec(cmds = "bundle install"))) {
            return false;
        }
        if (this.needClean) {
            cmds = "";
            if (this.useBundler) {
                cmds = "bundle exec ";
            }
            if (!(result = this.cmdLauncher.exec(cmds = cmds + "rake clean:all"))) {
                return false;
            }
        }
        if (this.installCocoaPods) {
            cmds = "";
            if (this.useBundler) {
                cmds = "bundle exec ";
            }
            if (!(result = this.cmdLauncher.exec(cmds = cmds + "rake pod:install"))) {
                return false;
            }
        }
        boolean success = false;
        if (this.platform.equals("ios") || this.platform.equals("tvos")) {
            success = this.execiOS();
        } else if (this.platform.equals("osx")) {
            success = this.execOSX();
        }
        if (this.outputResult) {
            this.printResult();
        }
        boolean noCrashed = this.checkFinishedWithoutCrash();
        if (!success) {
            if (noCrashed) {
                build.setResult(Result.UNSTABLE);
            } else {
                build.setResult(Result.FAILURE);
                this.printError();
            }
        }
        return true;
    }

    private boolean execOSX() {
        OutputStream outputStream;
        String cmds = "rake ";
        if (this.getUseBundler()) {
            cmds = "bundle exec rake ";
        }
        cmds = cmds + this.rakeTask;
        cmds = cmds + " output=" + this.outputStyle;
        try {
            FilePath fp = this.cmdLauncher.getWorkspaceFilePath(this.outputFileName);
            outputStream = fp.write();
        }
        catch (Exception e) {
            return false;
        }
        return this.cmdLauncher.exec(cmds, outputStream);
    }

    private boolean execiOS() {
        String cmds = "rake ";
        if (this.getUseBundler()) {
            cmds = "bundle exec rake ";
        }
        cmds = cmds + this.rakeTask;
        if (this.deviceName != null && this.deviceName.length() > 0) {
            cmds = cmds + " device_name='" + this.deviceName + "'";
        }
        if (this.simulatorVersion != null && this.simulatorVersion.length() > 0) {
            cmds = cmds + " target=" + this.simulatorVersion;
        }
        cmds = cmds + " output=" + this.outputStyle;
        String output = this.cmdLauncher.getProjectWorkspace() + "/" + this.outputFileName;
        String error = this.cmdLauncher.getProjectWorkspace() + "/.jenkins-error";
        cmds = cmds + " SIM_STDOUT_PATH='" + output + "' SIM_STDERR_PATH='" + error + "'";
        return this.cmdLauncher.exec(cmds);
    }

    private String readResult(String path) {
        String result = null;
        try {
            FilePath fp = this.cmdLauncher.getWorkspaceFilePath(path);
            if (fp.exists()) {
                result = fp.readToString().trim();
            }
            return result;
        }
        catch (Exception e) {
            return result;
        }
    }

    private void printResult() {
        String result = this.readResult(this.outputFileName);
        if (result == null) {
            return;
        }
        this.cmdLauncher.printLog(result + "\n");
    }

    private void printError() {
        String error = this.readResult(".jenkins-error");
        if (error == null) {
            return;
        }
        this.cmdLauncher.printLog(error + "\n");
    }

    private boolean checkFinishedWithoutCrash() {
        String result = this.readResult(this.outputFileName);
        if (result == null) {
            return false;
        }
        String lastLine = null;
        int index = result.lastIndexOf("\n");
        if (index != -1 && index != result.length()) {
            lastLine = result.substring(index + 1);
        }
        if (lastLine == null) {
            return false;
        }
        return lastLine.matches("^# \\d+ tests.+");
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }
}

